/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.nar;

import java.io.Closeable;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarClassLoadersHolder;
import org.apache.nifi.nar.NarThreadContextClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NarCloseable
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(NarCloseable.class);
    private final ClassLoader toSet;

    public static NarCloseable withNarLoader() {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(NarThreadContextClassLoader.getInstance());
        return new NarCloseable(current);
    }

    public static NarCloseable withComponentNarLoader(ExtensionManager extensionManager, Class componentClass, String componentIdentifier) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        Object componentClassLoader = extensionManager.getInstanceClassLoader(componentIdentifier);
        if (componentClassLoader == null) {
            componentClassLoader = componentClass.getClassLoader();
        }
        Thread.currentThread().setContextClassLoader((ClassLoader)componentClassLoader);
        return new NarCloseable(current);
    }

    public static NarCloseable withComponentNarLoader(ClassLoader componentNarLoader) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(componentNarLoader);
        return new NarCloseable(current);
    }

    public static NarCloseable withFrameworkNar() {
        ClassLoader frameworkClassLoader;
        try {
            frameworkClassLoader = NarClassLoadersHolder.getInstance().getFrameworkBundle().getClassLoader();
        }
        catch (Exception e) {
            logger.error("Unable to access Framework ClassLoader due to " + e + ". Will continue without changing ClassLoaders.");
            if (logger.isDebugEnabled()) {
                logger.error("", (Throwable)e);
            }
            return new NarCloseable(null);
        }
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(frameworkClassLoader);
        return new NarCloseable(current);
    }

    private NarCloseable(ClassLoader toSet) {
        this.toSet = toSet;
    }

    @Override
    public void close() {
        if (this.toSet != null) {
            Thread.currentThread().setContextClassLoader(this.toSet);
        }
    }
}

