/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue.clustered.partition;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.controller.queue.clustered.partition.FlowFilePartitioner;
import org.apache.nifi.controller.queue.clustered.partition.QueuePartition;
import org.apache.nifi.controller.repository.FlowFileRecord;

public class NonLocalPartitionPartitioner
implements FlowFilePartitioner {
    private final AtomicLong counter = new AtomicLong(0L);

    @Override
    public QueuePartition getPartition(FlowFileRecord flowFile, QueuePartition[] partitions, QueuePartition localPartition) {
        QueuePartition remotePartition = null;
        long startIndex = this.counter.getAndIncrement();
        int numPartitions = partitions.length;
        for (int i = 0; i < numPartitions && remotePartition == null; ++i) {
            int index = (int)((startIndex + (long)i) % (long)numPartitions);
            QueuePartition partition = partitions[index];
            if (partition.equals(localPartition)) continue;
            remotePartition = partition;
        }
        if (remotePartition == null) {
            throw new IllegalStateException("Could not determine a remote partition");
        }
        return remotePartition;
    }

    @Override
    public boolean isRebalanceOnClusterResize() {
        return true;
    }

    @Override
    public boolean isRebalanceOnFailure() {
        return true;
    }
}

