/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.queue;

import java.util.Collection;
import java.util.Set;
import org.apache.nifi.controller.queue.DropFlowFileAction;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.queue.FlowFileQueueContents;
import org.apache.nifi.controller.queue.PollStrategy;
import org.apache.nifi.controller.queue.SwappablePriorityQueue;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.FlowFileSwapManager;
import org.apache.nifi.events.EventReporter;

public class BlockingSwappablePriorityQueue
extends SwappablePriorityQueue {
    private final Object monitor = new Object();

    public BlockingSwappablePriorityQueue(FlowFileSwapManager swapManager, int swapThreshold, EventReporter eventReporter, FlowFileQueue flowFileQueue, DropFlowFileAction dropAction, String partitionName) {
        super(swapManager, swapThreshold, eventReporter, flowFileQueue, dropAction, partitionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(FlowFileRecord flowFile) {
        super.put(flowFile);
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Collection<FlowFileRecord> flowFiles) {
        super.putAll(flowFiles);
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowFileRecord poll(Set<FlowFileRecord> expiredRecords, long expirationMillis, long waitMillis, PollStrategy pollStrategy) throws InterruptedException {
        long maxTimestamp = System.currentTimeMillis() + waitMillis;
        Object object = this.monitor;
        synchronized (object) {
            FlowFileRecord flowFile = null;
            do {
                if ((flowFile = super.poll(expiredRecords, expirationMillis, pollStrategy)) != null) {
                    return flowFile;
                }
                this.monitor.wait(waitMillis);
            } while (System.currentTimeMillis() < maxTimestamp);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inheritQueueContents(FlowFileQueueContents queueContents) {
        Object object = this.monitor;
        synchronized (object) {
            super.inheritQueueContents(queueContents);
        }
    }
}

