/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.protocol.component.api;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.nifi.scheduling.SchedulingStrategy;

@ApiModel
public class SchedulingDefaults
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SchedulingStrategy defaultSchedulingStrategy;
    private long defaultSchedulingPeriodMillis;
    private long penalizationPeriodMillis;
    private long yieldDurationMillis;
    private long defaultRunDurationNanos;
    private String defaultMaxConcurrentTasks;
    private Map<String, Integer> defaultConcurrentTasksBySchedulingStrategy;
    private Map<String, String> defaultSchedulingPeriodsBySchedulingStrategy;

    @ApiModelProperty(value="The name of the default scheduling strategy")
    public SchedulingStrategy getDefaultSchedulingStrategy() {
        return this.defaultSchedulingStrategy;
    }

    public void setDefaultSchedulingStrategy(SchedulingStrategy defaultSchedulingStrategy) {
        this.defaultSchedulingStrategy = defaultSchedulingStrategy;
    }

    @ApiModelProperty(value="The default scheduling period in milliseconds")
    public long getDefaultSchedulingPeriodMillis() {
        return this.defaultSchedulingPeriodMillis;
    }

    public void setDefaultSchedulingPeriodMillis(long defaultSchedulingPeriodMillis) {
        this.defaultSchedulingPeriodMillis = defaultSchedulingPeriodMillis;
    }

    @ApiModelProperty(value="The default penalization period in milliseconds")
    public long getPenalizationPeriodMillis() {
        return this.penalizationPeriodMillis;
    }

    public void setPenalizationPeriodMillis(long penalizationPeriodMillis) {
        this.penalizationPeriodMillis = penalizationPeriodMillis;
    }

    @ApiModelProperty(value="The default yield duration in milliseconds")
    public long getYieldDurationMillis() {
        return this.yieldDurationMillis;
    }

    public void setYieldDurationMillis(long yieldDurationMillis) {
        this.yieldDurationMillis = yieldDurationMillis;
    }

    @ApiModelProperty(value="The default run duration in nano-seconds")
    public long getDefaultRunDurationNanos() {
        return this.defaultRunDurationNanos;
    }

    public void setDefaultRunDurationNanos(long defaultRunDurationNanos) {
        this.defaultRunDurationNanos = defaultRunDurationNanos;
    }

    @ApiModelProperty(value="The default concurrent tasks")
    public String getDefaultMaxConcurrentTasks() {
        return this.defaultMaxConcurrentTasks;
    }

    public void setDefaultMaxConcurrentTasks(String defaultMaxConcurrentTasks) {
        this.defaultMaxConcurrentTasks = defaultMaxConcurrentTasks;
    }

    @ApiModelProperty(value="The default concurrent tasks for each scheduling strategy")
    public Map<String, Integer> getDefaultConcurrentTasksBySchedulingStrategy() {
        return this.defaultConcurrentTasksBySchedulingStrategy != null ? Collections.unmodifiableMap(this.defaultConcurrentTasksBySchedulingStrategy) : null;
    }

    public void setDefaultConcurrentTasksBySchedulingStrategy(Map<String, Integer> defaultConcurrentTasksBySchedulingStrategy) {
        this.defaultConcurrentTasksBySchedulingStrategy = defaultConcurrentTasksBySchedulingStrategy;
    }

    @ApiModelProperty(value="The default scheduling period for each scheduling strategy")
    public Map<String, String> getDefaultSchedulingPeriodsBySchedulingStrategy() {
        return this.defaultSchedulingPeriodsBySchedulingStrategy != null ? Collections.unmodifiableMap(this.defaultSchedulingPeriodsBySchedulingStrategy) : null;
    }

    public void setDefaultSchedulingPeriodsBySchedulingStrategy(Map<String, String> defaultSchedulingPeriodsBySchedulingStrategy) {
        this.defaultSchedulingPeriodsBySchedulingStrategy = defaultSchedulingPeriodsBySchedulingStrategy;
    }
}

