/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.lsp.client.options;

import java.io.File;
import java.util.Locale;
import java.util.Set;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.lsp.client.options.LanguageStorage.LanguageDescription;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbBundle.Messages;

@Messages("BTN_Select=Select")
public class LanguageDescriptionPanel extends javax.swing.JPanel {

    private final String id;

    public LanguageDescriptionPanel(LanguageDescription desc, Set<String> usedIds) {
        initComponents();
        if (desc == null) {
            String id;
            String base = "";
            OUTER: while (true) {
                for (char c = 'a'; c <= 'z'; c++) {
                    if (usedIds.add(base + c)) {
                        id = base + c;
                        break OUTER;
                    }
                }
                base = "a";
            }
            this.id = id;
        } else {
            this.id = desc.id;
            this.extensions.setText(desc.extensions);
            this.syntax.setText(desc.syntaxGrammar);
            this.server.setText(desc.languageServer);
            this.name.setText(desc.name);
            this.icon.setText(desc.icon);
            this.debugger.setSelected(desc.debugger);
        }
    }

    public LanguageDescription getDescription() {
        return new LanguageDescription(id, this.extensions.getText(), this.syntax.getText(), this.server.getText(), this.name.getText(), this.icon.getText(), this.debugger.isSelected());
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        JLabel nameLabel = new JLabel();
        JLabel extensionsLabel = new JLabel();
        JLabel grammarLabel = new JLabel();
        JLabel serverLabel = new JLabel();
        name = new JTextField();
        extensions = new JTextField();
        syntax = new JTextField();
        server = new JTextField();
        JButton browseGrammar = new JButton();
        JButton browseServer = new JButton();
        JSeparator extraOptionsSeparator = new JSeparator();
        JLabel optionalParams = new JLabel();
        JLabel iconLabel = new JLabel();
        icon = new JTextField();
        JButton browseIcon = new JButton();
        debugger = new JCheckBox();

        nameLabel.setLabelFor(name);
        Mnemonics.setLocalizedText(nameLabel, NbBundle.getMessage(LanguageDescriptionPanel.class, "LanguageDescriptionPanel.nameLabel.text")); // NOI18N

        extensionsLabel.setLabelFor(extensions);
        Mnemonics.setLocalizedText(extensionsLabel, NbBundle.getMessage(LanguageDescriptionPanel.class, "LanguageDescriptionPanel.extensionsLabel.text")); // NOI18N

        grammarLabel.setLabelFor(syntax);
        Mnemonics.setLocalizedText(grammarLabel, NbBundle.getMessage(LanguageDescriptionPanel.class, "LanguageDescriptionPanel.grammarLabel.text")); // NOI18N

        serverLabel.setLabelFor(server);
        Mnemonics.setLocalizedText(serverLabel, NbBundle.getMessage(LanguageDescriptionPanel.class, "LanguageDescriptionPanel.serverLabel.text")); // NOI18N

        name.setText(NbBundle.getMessage(LanguageDescriptionPanel.class, "LanguageDescriptionPanel.name.text")); // NOI18N

        extensions.setText(NbBundle.getMessage(LanguageDescriptionPanel.class, "LanguageDescriptionPanel.extensions.text")); // NOI18N

        syntax.setText(NbBundle.getMessage(LanguageDescriptionPanel.class, "LanguageDescriptionPanel.syntax.text")); // NOI18N

        server.setText(NbBundle.getMessage(LanguageDescriptionPanel.class, "LanguageDescriptionPanel.server.text")); // NOI18N

        Mnemonics.setLocalizedText(browseGrammar, NbBundle.getMessage(LanguageDescriptionPanel.class, "LanguageDescriptionPanel.browseGrammar.text")); // NOI18N
        browseGrammar.addActionListener(this::browseGrammarActionPerformed);

        Mnemonics.setLocalizedText(browseServer, NbBundle.getMessage(LanguageDescriptionPanel.class, "LanguageDescriptionPanel.browseServer.text")); // NOI18N
        browseServer.addActionListener(this::browseServerActionPerformed);

        Mnemonics.setLocalizedText(optionalParams, NbBundle.getMessage(LanguageDescriptionPanel.class, "LanguageDescriptionPanel.optionalParams.text")); // NOI18N

        iconLabel.setLabelFor(icon);
        Mnemonics.setLocalizedText(iconLabel, NbBundle.getMessage(LanguageDescriptionPanel.class, "LanguageDescriptionPanel.iconLabel.text")); // NOI18N

        icon.setText(NbBundle.getMessage(LanguageDescriptionPanel.class, "LanguageDescriptionPanel.icon.text")); // NOI18N

        Mnemonics.setLocalizedText(browseIcon, NbBundle.getMessage(LanguageDescriptionPanel.class, "LanguageDescriptionPanel.browseIcon.text")); // NOI18N
        browseIcon.addActionListener(this::browseIconActionPerformed);

        Mnemonics.setLocalizedText(debugger, NbBundle.getMessage(LanguageDescriptionPanel.class, "LanguageDescriptionPanel.debugger.text")); // NOI18N

        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(optionalParams)
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(extraOptionsSeparator))
                    .addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)
                            .addComponent(nameLabel)
                            .addComponent(iconLabel))
                        .addGap(68, 68, 68)
                        .addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING)
                            .addComponent(icon, GroupLayout.DEFAULT_SIZE, 273, Short.MAX_VALUE)
                            .addComponent(name))
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(browseIcon))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)
                            .addComponent(grammarLabel)
                            .addComponent(serverLabel)
                            .addComponent(extensionsLabel, GroupLayout.PREFERRED_SIZE, 101, GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)
                            .addComponent(extensions)
                            .addComponent(server)
                            .addComponent(syntax))
                        .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)
                            .addComponent(browseGrammar, GroupLayout.Alignment.TRAILING)
                            .addComponent(browseServer, GroupLayout.Alignment.TRAILING)))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(debugger)
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(extensionsLabel)
                    .addComponent(extensions, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(grammarLabel)
                    .addComponent(syntax, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                    .addComponent(browseGrammar))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(server, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                    .addComponent(serverLabel)
                    .addComponent(browseServer))
                .addGap(18, 18, 18)
                .addComponent(debugger)
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING)
                    .addComponent(optionalParams)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(7, 7, 7)
                        .addComponent(extraOptionsSeparator, GroupLayout.PREFERRED_SIZE, 11, GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(nameLabel)
                    .addComponent(name, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE)
                    .addComponent(icon, GroupLayout.PREFERRED_SIZE, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE)
                    .addComponent(iconLabel)
                    .addComponent(browseIcon))
                .addContainerGap(GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    @Messages("DESC_JSONFilter=Grammars (.json, .xml, .tmLanguage)")
    private void browseGrammarActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseGrammarActionPerformed
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter() {
            @Override
            public boolean accept(File f) {
                return f.isDirectory() ||
                       f.getName().toLowerCase(Locale.ENGLISH).endsWith(".json") ||
                       f.getName().toLowerCase(Locale.ENGLISH).endsWith(".xml") ||
                       f.getName().toLowerCase(Locale.ENGLISH).endsWith(".tmlanguage");
            }

            @Override
            public String getDescription() {
                return Bundle.DESC_JSONFilter();
            }
        });
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setSelectedFile(new File(syntax.getText()));
        if (chooser.showDialog(null, Bundle.BTN_Select()) == JFileChooser.APPROVE_OPTION) {
            syntax.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }//GEN-LAST:event_browseGrammarActionPerformed

    @Messages("DESC_IconFilter=Icons (.png, .jpg, .gif)")
    private void browseIconActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseIconActionPerformed
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(new FileFilter() {
            @Override
            public boolean accept(File f) {
                return f.isDirectory() ||
                       f.getName().toLowerCase(Locale.ENGLISH).endsWith(".png") ||
                       f.getName().toLowerCase(Locale.ENGLISH).endsWith(".jpg") ||
                       f.getName().toLowerCase(Locale.ENGLISH).endsWith(".gif");
            }

            @Override
            public String getDescription() {
                return Bundle.DESC_IconFilter();
            }
        });
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setSelectedFile(new File(icon.getText()));
        if (chooser.showDialog(null, Bundle.BTN_Select()) == JFileChooser.APPROVE_OPTION) {
            icon.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }//GEN-LAST:event_browseIconActionPerformed

    private void browseServerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_browseServerActionPerformed
        JFileChooser chooser = new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(true);
        chooser.setSelectedFile(new File(server.getText()));
        if (chooser.showDialog(null, Bundle.BTN_Select()) == JFileChooser.APPROVE_OPTION) {
            server.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }//GEN-LAST:event_browseServerActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private JCheckBox debugger;
    private JTextField extensions;
    private JTextField icon;
    private JTextField name;
    private JTextField server;
    private JTextField syntax;
    // End of variables declaration//GEN-END:variables
}
