/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.io.CharConversionException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.project.ui.Bundle;
import org.netbeans.modules.project.ui.ExitDialog;
import org.netbeans.modules.project.ui.ProjectTab;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.ui.support.ProjectConvertors;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProjectUtilities {
    static final String OPEN_FILES_NS = "http://www.netbeans.org/ns/projectui-open-files/1";
    static final String OPEN_FILES_NS2 = "http://www.netbeans.org/ns/projectui-open-files/2";
    static final String OPEN_FILES_ELEMENT = "open-files";
    static final String FILE_ELEMENT = "file";
    static final String GROUP_ELEMENT = "group";
    static final String NAME_ATTR = "name";
    static OpenCloseProjectDocument OPEN_CLOSE_PROJECT_DOCUMENT_IMPL = new OpenCloseProjectDocument(){

        @Override
        public boolean open(FileObject fo) {
            DataObject dobj;
            try {
                dobj = DataObject.find(fo);
            }
            catch (DataObjectNotFoundException donfo) {
                assert (false) : "DataObject must exist for " + fo;
                return false;
            }
            EditCookie ec = dobj.getLookup().lookup(EditCookie.class);
            OpenCookie oc = dobj.getLookup().lookup(OpenCookie.class);
            Openable o = dobj.getLookup().lookup(Openable.class);
            if (ec != null) {
                ec.edit();
            } else if (oc != null) {
                oc.open();
            } else if (o != null) {
                o.open();
            } else {
                ERR.log(Level.INFO, "No EditCookie nor OpenCookie nor Openable for {0}", dobj);
                return false;
            }
            return true;
        }

        @Override
        public Map<Project, Set<String>> close(Project[] projects, boolean notifyUI) {
            Wrapper wr = new Wrapper();
            wr.urls4project = new HashMap<Project, Set<String>>();
            this.doClose(projects, notifyUI, wr);
            return wr.urls4project;
        }

        private void doClose(Project[] projects, boolean notifyUI, Wrapper wr) {
            List<Project> listOfProjects = Arrays.asList(projects);
            for (Project p : listOfProjects) {
                wr.urls4project.put(p, new LinkedHashSet());
            }
            HashSet<DataObject> openFiles = new HashSet<DataObject>();
            final HashSet<TopComponent> tc2close = new HashSet<TopComponent>();
            ERR.finer("Closing TCs");
            Set<TopComponent> openedTC = this.getOpenedTCs();
            for (TopComponent tc : openedTC) {
                DataObject dobj = tc.getLookup().lookup(DataObject.class);
                if (dobj != null) {
                    FileObject fobj = dobj.getPrimaryFile();
                    Project owner = ProjectConvertors.getNonConvertorOwner(fobj);
                    ERR.log(Level.FINER, "Found {0} owned by {1} in {2} of {3}", new Object[]{fobj, owner, tc.getName(), tc.getClass()});
                    if (!listOfProjects.contains(owner)) continue;
                    if (notifyUI) {
                        openFiles.add(dobj);
                        tc2close.add(tc);
                    } else if (!dobj.isModified()) {
                        tc2close.add(tc);
                    }
                    Set<String> pwnr = wr.urls4project.get(owner);
                    assert (pwnr != null) : "Owner project for file:" + fobj + " prj:" + owner;
                    FileObject pf = fobj;
                    assert (pf != null);
                    URL u = pf.toURL();
                    assert (u != null);
                    String uex = u.toExternalForm();
                    pwnr.add(uex);
                    continue;
                }
                ERR.log(Level.FINE, "#194243: no DataObject in lookup of {0} of {1}", new Object[]{tc.getName(), tc.getClass()});
            }
            if (notifyUI) {
                for (DataObject dobj : DataObject.getRegistry().getModifiedSet()) {
                    FileObject fobj = dobj.getPrimaryFile();
                    Project owner = ProjectConvertors.getNonConvertorOwner(fobj);
                    if (!listOfProjects.contains(owner) || openFiles.contains(dobj)) continue;
                    openFiles.add(dobj);
                }
            }
            if (!notifyUI || !openFiles.isEmpty() && ExitDialog.showDialog(openFiles)) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        for (TopComponent tc : tc2close) {
                            tc.close();
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    r.run();
                } else {
                    SwingUtilities.invokeLater(r);
                }
            } else if (!openFiles.isEmpty()) {
                wr.urls4project = null;
            }
        }

        private Set<TopComponent> getOpenedTCs() {
            final HashSet<TopComponent> openedTC = new HashSet<TopComponent>();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    WindowManager wm = WindowManager.getDefault();
                    for (Mode mode : wm.getModes()) {
                        if (!wm.isEditorMode(mode)) continue;
                        ERR.log(Level.FINER, "Closing TCs in mode {0}", mode.getName());
                        openedTC.addAll(Arrays.asList(wm.getOpenedTopComponents(mode)));
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(r);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace(ex);
                }
            }
            return openedTC;
        }
    };
    private static final Logger ERR = Logger.getLogger(ProjectUtilities.class.getName());

    private ProjectUtilities() {
    }

    public static void selectAndExpandProject(final Project p) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectTab ptLogial = ProjectTab.findDefault("projectTabLogical_tc");
                Node root = ptLogial.getExplorerManager().getRootContext();
                Node projNode = null;
                for (Node n : root.getChildren().getNodes()) {
                    Project prj = n.getLookup().lookup(Project.class);
                    if (prj == null || !prj.getProjectDirectory().equals(p.getProjectDirectory())) continue;
                    projNode = n;
                    break;
                }
                if (projNode == null) {
                    projNode = root.getChildren().findChild(ProjectUtils.getInformation(p).getName());
                }
                if (projNode != null) {
                    try {
                        ptLogial.getExplorerManager().setSelectedNodes(new Node[]{projNode});
                        ptLogial.expandNode(projNode);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public static void openAndSelectNewObject(final DataObject newDo) {
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                Node node = newDo.getNodeDelegate();
                Action a = node.getPreferredAction();
                if (a instanceof ContextAwareAction) {
                    a = ((ContextAwareAction)a).createContextAwareInstance(node.getLookup());
                }
                if (a != null) {
                    a.actionPerformed(new ActionEvent(node, 1001, ""));
                }
                final ProjectTab ptLogical = ProjectTab.findDefault("projectTabLogical_tc");
                final ProjectTab ptPhysical = ProjectTab.findDefault("projectTab_tc");
                ProjectTab.RP.post(new Runnable(){

                    @Override
                    public void run() {
                        ProjectTab tab = ptLogical;
                        Node n = tab.findNode(newDo.getPrimaryFile());
                        if (n == null) {
                            tab = ptPhysical;
                            n = tab.findNode(newDo.getPrimaryFile());
                        }
                        if (n != null) {
                            tab.selectNode(n);
                        }
                    }
                });
            }
        });
    }

    public static void makeProjectTabVisible() {
        if (Boolean.getBoolean("project.tab.no.selection")) {
            return;
        }
        ProjectTab ptLogical = ProjectTab.findDefault("projectTabLogical_tc");
        ptLogical.open();
        ptLogical.requestActive();
    }

    public static String canUseFileName(FileObject targetFolder, String folderName, String newObjectName, String extension, boolean allowFileSeparator, boolean freeFileExtension) {
        FileObject targetDir;
        assert (newObjectName != null);
        boolean allowSlash = false;
        boolean allowBackslash = false;
        int errorVariant = 0;
        if (allowFileSeparator) {
            if (File.separatorChar == '\\') {
                errorVariant = 3;
                allowBackslash = true;
                allowSlash = true;
            } else {
                errorVariant = 1;
                allowSlash = true;
            }
        }
        if (!allowSlash && newObjectName.indexOf(47) != -1 || !allowBackslash && newObjectName.indexOf(92) != -1) {
            assert (errorVariant == 0 || errorVariant == 1) : "Invalid error variant: " + errorVariant;
            return Bundle.MSG_not_valid_filename(ProjectUtilities.safeEncode(newObjectName), errorVariant);
        }
        if (targetFolder == null) {
            return Bundle.MSG_fs_or_folder_does_not_exist();
        }
        FileObject fileObject = targetDir = folderName != null ? targetFolder.getFileObject(folderName) : targetFolder;
        if (targetDir != null ? targetDir.isValid() && !targetDir.canWrite() : !targetFolder.canWrite()) {
            return Bundle.MSG_fs_is_readonly();
        }
        StringBuilder relFileName = new StringBuilder();
        if (folderName != null) {
            if (!allowBackslash && folderName.indexOf(92) != -1) {
                return Bundle.MSG_not_valid_folder(ProjectUtilities.safeEncode(folderName), 1);
            }
            relFileName.append(folderName);
            relFileName.append('/');
        }
        relFileName.append(newObjectName);
        String ext = "";
        if (!(extension == null || extension.length() == 0 || freeFileExtension && newObjectName.indexOf(46) != -1)) {
            ext = "." + extension;
            relFileName.append(ext);
        }
        if (targetFolder.getFileObject(relFileName.toString()) != null) {
            return Bundle.MSG_file_already_exist(ProjectUtilities.safeEncode(newObjectName + ext));
        }
        return null;
    }

    private static String safeEncode(String text) {
        if (text.length() > 30) {
            text = text.substring(0, 30) + '\u2026';
        }
        try {
            return XMLUtil.toElementContent(text.replaceAll("\\s+", " "));
        }
        catch (CharConversionException ex) {
            return text;
        }
    }

    public static boolean closeAllDocuments(Project[] projects, boolean notifyUI, String groupName) {
        if (projects == null) {
            throw new IllegalArgumentException("No projects are specified.");
        }
        if (projects.length == 0) {
            return true;
        }
        Map<Project, Set<String>> urls4project = OPEN_CLOSE_PROJECT_DOCUMENT_IMPL.close(projects, notifyUI);
        if (urls4project != null) {
            for (Map.Entry<Project, Set<String>> entry : urls4project.entrySet()) {
                ProjectUtilities.storeProjectOpenFiles(entry.getKey(), entry.getValue(), groupName);
            }
        }
        return urls4project != null;
    }

    public static void storeProjectOpenFiles(Project p, Set<String> urls, String groupName) {
        AuxiliaryConfiguration aux = ProjectUtils.getAuxiliaryConfiguration(p);
        Set<String> openFileUrls = ProjectUtilities.getOpenFilesUrls(p, groupName);
        if (urls.isEmpty() && openFileUrls.isEmpty()) {
            return;
        }
        if (urls.size() == openFileUrls.size()) {
            boolean same = true;
            for (String url : openFileUrls) {
                if (urls.contains(url)) continue;
                same = false;
                break;
            }
            if (same) {
                return;
            }
        }
        aux.removeConfigurationFragment(OPEN_FILES_ELEMENT, OPEN_FILES_NS, false);
        Element openFiles = aux.getConfigurationFragment(OPEN_FILES_ELEMENT, OPEN_FILES_NS2, false);
        if (openFiles == null) {
            Document xml = XMLUtil.createDocument(OPEN_FILES_ELEMENT, OPEN_FILES_NS2, null, null);
            openFiles = xml.createElementNS(OPEN_FILES_NS2, OPEN_FILES_ELEMENT);
        }
        NodeList groups = openFiles.getElementsByTagNameNS(OPEN_FILES_NS2, GROUP_ELEMENT);
        for (int i = 0; i < groups.getLength(); ++i) {
            Element g = (Element)groups.item(i);
            String attr = g.getAttribute(NAME_ATTR);
            if (!attr.equals(groupName) && (!attr.equals("") || groupName != null)) continue;
            openFiles.removeChild(g);
            break;
        }
        Element groupEl = openFiles.getOwnerDocument().createElementNS(OPEN_FILES_NS2, GROUP_ELEMENT);
        if (groupName != null) {
            groupEl.setAttribute(NAME_ATTR, groupName);
        }
        openFiles.appendChild(groupEl);
        for (String url : urls) {
            Element fileEl = groupEl.getOwnerDocument().createElementNS(OPEN_FILES_NS2, FILE_ELEMENT);
            fileEl.appendChild(fileEl.getOwnerDocument().createTextNode(url));
            groupEl.appendChild(fileEl);
        }
        aux.putConfigurationFragment(openFiles, false);
    }

    public static Set<FileObject> openProjectFiles(Project p) {
        Group grp = Group.getActiveGroup();
        return ProjectUtilities.openProjectFiles(p, grp);
    }

    public static Set<FileObject> openProjectFiles(Project p, Group grp) {
        String groupName = grp == null ? null : grp.getName();
        ERR.log(Level.FINE, "Trying to open files from {0}...", p);
        Set<String> urls = ProjectUtilities.getOpenFilesUrls(p, groupName);
        HashSet<FileObject> toRet = new HashSet<FileObject>();
        for (String url : urls) {
            FileObject fo;
            ERR.log(Level.FINE, "Will try to open {0}", url);
            try {
                fo = URLMapper.findFileObject(new URL(url));
            }
            catch (MalformedURLException mue) {
                assert (false) : "MalformedURLException in " + url;
                continue;
            }
            if (fo == null || !fo.isValid()) {
                ERR.log(Level.FINE, "Could not find {0}", url);
                continue;
            }
            if (ProjectConvertors.getNonConvertorOwner(fo) != p) {
                ERR.log(Level.FINE, "File {0} doesn''t belong to project at {1}", new Object[]{url, p.getProjectDirectory().getPath()});
                continue;
            }
            OPEN_CLOSE_PROJECT_DOCUMENT_IMPL.open(fo);
            toRet.add(fo);
        }
        return toRet;
    }

    private static Set<String> getOpenFilesUrls(Project p, String groupName) {
        AuxiliaryConfiguration aux = ProjectUtils.getAuxiliaryConfiguration(p);
        Element openFiles = aux.getConfigurationFragment(OPEN_FILES_ELEMENT, OPEN_FILES_NS2, false);
        if (openFiles == null) {
            return Collections.emptySet();
        }
        Element groupEl = null;
        NodeList groups = openFiles.getElementsByTagNameNS(OPEN_FILES_NS2, GROUP_ELEMENT);
        for (int i = 0; i < groups.getLength(); ++i) {
            Element g = (Element)groups.item(i);
            String attr = g.getAttribute(NAME_ATTR);
            if (!attr.equals(groupName) && (!attr.equals("") || groupName != null)) continue;
            groupEl = g;
            break;
        }
        if (groupEl == null) {
            return Collections.emptySet();
        }
        NodeList list = groupEl.getElementsByTagNameNS(OPEN_FILES_NS2, FILE_ELEMENT);
        HashSet<String> toRet = new HashSet<String>();
        for (int i = 0; i < list.getLength(); ++i) {
            String url = list.item(i).getChildNodes().item(0).getNodeValue();
            toRet.add(url);
        }
        return toRet;
    }

    static interface OpenCloseProjectDocument {
        public boolean open(FileObject var1);

        public Map<Project, Set<String>> close(Project[] var1, boolean var2);
    }

    public static class WaitCursor
    implements Runnable {
        private boolean show;

        private WaitCursor(boolean show) {
            this.show = show;
        }

        public static void show() {
            WaitCursor.invoke(new WaitCursor(true));
        }

        public static void hide() {
            WaitCursor.invoke(new WaitCursor(false));
        }

        private static void invoke(WaitCursor wc) {
            if (GraphicsEnvironment.isHeadless()) {
                return;
            }
            if (SwingUtilities.isEventDispatchThread()) {
                wc.run();
            } else {
                SwingUtilities.invokeLater(wc);
            }
        }

        @Override
        public void run() {
            try {
                JFrame f = (JFrame)WindowManager.getDefault().getMainWindow();
                Component c = f.getGlassPane();
                c.setVisible(this.show);
                c.setCursor(this.show ? Cursor.getPredefinedCursor(3) : null);
            }
            catch (NullPointerException npe) {
                Exceptions.printStackTrace(npe);
            }
        }
    }

    private static class Wrapper {
        Map<Project, Set<String>> urls4project;

        private Wrapper() {
        }
    }
}

