/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import jpt.sun.source.tree.BlockTree;
import jpt.sun.source.tree.CompilationUnitTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.NewClassTree;
import jpt.sun.source.tree.ParameterizedTypeTree;
import jpt.sun.source.tree.Scope;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.util.SourcePositions;
import jpt.sun.source.util.TreePath;
import jpt.sun.source.util.Trees;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.Name;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.element.VariableElement;
import jpt30.lang.model.type.ArrayType;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.ExecutableType;
import jpt30.lang.model.type.TypeKind;
import jpt30.lang.model.type.TypeMirror;
import jpt30.lang.model.util.Types;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.modules.java.completion.BaseTask;
import org.netbeans.modules.java.completion.JavaCompletionTask;
import org.openide.util.NbBundle;

public final class JavaTooltipTask
extends BaseTask {
    private static final String INIT = "<init>";
    private static final String THIS_KEYWORD = "this";
    private static final String SUPER_KEYWORD = "super";
    private int anchorOffset;
    private List<List<String>> toolTipData;
    private int toolTipIndex;
    private int toolTipOffset;

    public static JavaTooltipTask create(int caretOffset, @NullAllowed Callable<Boolean> cancel) {
        return new JavaTooltipTask(caretOffset, cancel);
    }

    private JavaTooltipTask(int caretOffset, Callable<Boolean> cancel) {
        super(caretOffset, cancel);
    }

    public List<List<String>> getTooltipData() {
        return this.toolTipData;
    }

    public int getTooltipIndex() {
        return this.toolTipIndex;
    }

    public int getAnchorOffset() {
        return this.anchorOffset;
    }

    public int getTooltipOffset() {
        return this.toolTipOffset;
    }

    @Override
    protected void resolve(CompilationController controller) throws IOException {
        BaseTask.Env env = this.getCompletionEnvironment(controller, true);
        if (env == null) {
            return;
        }
        Tree lastTree = null;
        int offset = env.getOffset();
        for (TreePath path = env.getPath(); path != null; path = path.getParentPath()) {
            int startPos;
            SourcePositions sourcePositions;
            CompilationUnitTree root;
            Tree tree = path.getLeaf();
            if (tree.getKind() == Tree.Kind.METHOD_INVOCATION) {
                MethodInvocationTree mi = (MethodInvocationTree)tree;
                root = env.getRoot();
                sourcePositions = env.getSourcePositions();
                startPos = lastTree != null ? (int)sourcePositions.getStartPosition(root, lastTree) : offset;
                List<Tree> argTypes = this.getArgumentsUpToPos(env, mi.getArguments(), (int)sourcePositions.getEndPosition(root, mi.getMethodSelect()), startPos, false);
                if (argTypes != null) {
                    controller.toPhase(JavaSource.Phase.RESOLVED);
                    TypeMirror[] types = new TypeMirror[argTypes.size()];
                    int j = 0;
                    for (Tree t : argTypes) {
                        types[j++] = controller.getTrees().getTypeMirror(new TreePath(path, t));
                    }
                    ExpressionTree mid = mi.getMethodSelect();
                    path = new TreePath(path, mid);
                    switch (mid.getKind()) {
                        case MEMBER_SELECT: {
                            ExpressionTree exp = ((MemberSelectTree)mid).getExpression();
                            path = new TreePath(path, exp);
                            final Trees trees = controller.getTrees();
                            TypeMirror type = trees.getTypeMirror(path);
                            Element element = trees.getElement(path);
                            final boolean isStatic = element != null && (element.getKind().isClass() || element.getKind().isInterface() || element.getKind() == ElementKind.TYPE_PARAMETER);
                            final boolean isSuperCall = element != null && element.getKind().isField() && element.getSimpleName().contentEquals(SUPER_KEYWORD);
                            final Scope scope = env.getScope();
                            TypeElement enclClass = scope.getEnclosingClass();
                            final TypeMirror enclType = enclClass != null ? enclClass.asType() : null;
                            ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                                @Override
                                public boolean accept(Element e, TypeMirror t) {
                                    return !(isStatic && !e.getModifiers().contains((Object)Modifier.STATIC) && e.getKind() != ElementKind.CONSTRUCTOR || t.getKind() == TypeKind.DECLARED && !trees.isAccessible(scope, e, (DeclaredType)(isSuperCall && enclType != null ? enclType : t)));
                                }
                            };
                            this.toolTipData = this.getMatchingParams(controller, type, controller.getElementUtilities().getMembers(type, acceptor), ((MemberSelectTree)mid).getIdentifier().toString(), types, controller.getTypes());
                            break;
                        }
                        case IDENTIFIER: {
                            final Scope scope = env.getScope();
                            TreeUtilities tu = controller.getTreeUtilities();
                            final Trees trees = controller.getTrees();
                            TypeElement enclClass = scope.getEnclosingClass();
                            final boolean isStatic = enclClass != null ? tu.isStaticContext(scope) || env.getPath().getLeaf().getKind() == Tree.Kind.BLOCK && ((BlockTree)env.getPath().getLeaf()).isStatic() : false;
                            ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                                @Override
                                public boolean accept(Element e, TypeMirror t) {
                                    switch (e.getKind()) {
                                        case CONSTRUCTOR: {
                                            return !e.getModifiers().contains((Object)Modifier.PRIVATE);
                                        }
                                        case METHOD: {
                                            return (!isStatic || e.getModifiers().contains((Object)Modifier.STATIC)) && trees.isAccessible(scope, e, (DeclaredType)t);
                                        }
                                    }
                                    return false;
                                }
                            };
                            String name = ((IdentifierTree)mid).getName().toString();
                            if (SUPER_KEYWORD.equals(name) && enclClass != null) {
                                TypeMirror superclass = enclClass.getSuperclass();
                                this.toolTipData = this.getMatchingParams(controller, superclass, controller.getElementUtilities().getMembers(superclass, acceptor), INIT, types, controller.getTypes());
                                break;
                            }
                            if (THIS_KEYWORD.equals(name) && enclClass != null) {
                                TypeMirror thisclass = enclClass.asType();
                                this.toolTipData = this.getMatchingParams(controller, thisclass, controller.getElementUtilities().getMembers(thisclass, acceptor), INIT, types, controller.getTypes());
                                break;
                            }
                            this.toolTipData = this.getMatchingParams(controller, enclClass != null ? enclClass.asType() : null, controller.getElementUtilities().getLocalMembersAndVars(scope, acceptor), name, types, controller.getTypes());
                            break;
                        }
                    }
                    this.toolTipIndex = types.length;
                    startPos = (int)sourcePositions.getEndPosition(env.getRoot(), mi.getMethodSelect());
                    String text = controller.getText().substring(startPos, offset);
                    int idx = text.indexOf(40);
                    this.anchorOffset = idx < 0 ? startPos : startPos + controller.getSnapshot().getOriginalOffset(idx);
                    idx = text.lastIndexOf(44);
                    int n = this.toolTipOffset = idx < 0 ? startPos : startPos + controller.getSnapshot().getOriginalOffset(idx);
                    if (this.toolTipOffset < this.anchorOffset) {
                        this.toolTipOffset = this.anchorOffset;
                    }
                    return;
                }
            } else if (tree.getKind() == Tree.Kind.NEW_CLASS) {
                NewClassTree nc = (NewClassTree)tree;
                root = env.getRoot();
                sourcePositions = env.getSourcePositions();
                startPos = lastTree != null ? (int)sourcePositions.getStartPosition(root, lastTree) : offset;
                int pos = (int)sourcePositions.getEndPosition(root, nc.getIdentifier());
                List<Tree> argTypes = this.getArgumentsUpToPos(env, nc.getArguments(), pos, startPos, false);
                if (argTypes != null) {
                    String text;
                    int idx;
                    controller.toPhase(JavaSource.Phase.RESOLVED);
                    TypeMirror[] types = new TypeMirror[argTypes.size()];
                    int j = 0;
                    for (Tree t : argTypes) {
                        types[j++] = controller.getTrees().getTypeMirror(new TreePath(path, t));
                    }
                    path = new TreePath(path, nc.getIdentifier());
                    final Trees trees = controller.getTrees();
                    TypeMirror type = trees.getTypeMirror(path);
                    if (type != null && type.getKind() == TypeKind.ERROR && path.getLeaf().getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                        path = new TreePath(path, ((ParameterizedTypeTree)path.getLeaf()).getType());
                        type = trees.getTypeMirror(path);
                    }
                    Element el = trees.getElement(path);
                    final Scope scope = env.getScope();
                    final boolean isAnonymous = nc.getClassBody() != null || el != null && (el.getKind().isInterface() || el.getModifiers().contains((Object)Modifier.ABSTRACT));
                    ElementUtilities.ElementAcceptor acceptor = new ElementUtilities.ElementAcceptor(){

                        @Override
                        public boolean accept(Element e, TypeMirror t) {
                            return e.getKind() == ElementKind.CONSTRUCTOR && (trees.isAccessible(scope, e, (DeclaredType)t) || isAnonymous && e.getModifiers().contains((Object)Modifier.PROTECTED));
                        }
                    };
                    this.toolTipData = this.getMatchingParams(controller, type, controller.getElementUtilities().getMembers(type, acceptor), INIT, types, controller.getTypes());
                    this.toolTipIndex = types.length;
                    if (pos < 0) {
                        path = path.getParentPath();
                        pos = (int)sourcePositions.getStartPosition(root, path.getLeaf());
                    }
                    this.anchorOffset = (idx = (text = controller.getText().substring(pos, offset)).indexOf(40)) < 0 ? pos : pos + controller.getSnapshot().getOriginalOffset(idx);
                    idx = text.lastIndexOf(44);
                    int n = this.toolTipOffset = idx < 0 ? pos : pos + controller.getSnapshot().getOriginalOffset(idx);
                    if (this.toolTipOffset < this.anchorOffset) {
                        this.toolTipOffset = this.anchorOffset;
                    }
                    return;
                }
            }
            lastTree = tree;
        }
    }

    private List<List<String>> getMatchingParams(CompilationInfo info, TypeMirror type, Iterable<? extends Element> elements, String name, TypeMirror[] argTypes, Types types) {
        ArrayList<List<String>> ret = new ArrayList<List<String>>();
        TypeUtilities tu = info.getTypeUtilities();
        block0: for (Element element : elements) {
            if (element.getKind() != ElementKind.CONSTRUCTOR && element.getKind() != ElementKind.METHOD || !name.contentEquals(element.getSimpleName())) continue;
            List<? extends VariableElement> params = ((ExecutableElement)element).getParameters();
            int parSize = params.size();
            boolean varArgs = ((ExecutableElement)element).isVarArgs();
            if (!varArgs && parSize < argTypes.length) continue;
            if (parSize == 0) {
                ret.add(Collections.singletonList(NbBundle.getMessage(JavaCompletionTask.class, "JCP-no-parameters")));
                continue;
            }
            ExecutableType eType = (ExecutableType)this.asMemberOf(element, type, types);
            Iterator<? extends TypeMirror> parIt = eType.getParameterTypes().iterator();
            TypeMirror param = null;
            for (int i = 0; i <= argTypes.length; ++i) {
                if (parIt.hasNext()) {
                    param = parIt.next();
                    if (!parIt.hasNext() && param.getKind() == TypeKind.ARRAY) {
                        param = ((ArrayType)param).getComponentType();
                    }
                } else if (!varArgs) continue block0;
                if (i == argTypes.length) {
                    ArrayList<String> paramStrings = new ArrayList<String>(parSize);
                    Iterator<? extends TypeMirror> tIt = eType.getParameterTypes().iterator();
                    Iterator<? extends VariableElement> it = params.iterator();
                    while (it.hasNext()) {
                        Name veName;
                        VariableElement ve = it.next();
                        StringBuilder sb = new StringBuilder();
                        sb.append(tu.getTypeName(tIt.next(), new TypeUtilities.TypeNameOptions[0]));
                        if (varArgs && !tIt.hasNext()) {
                            sb.delete(sb.length() - 2, sb.length()).append("...");
                        }
                        if ((veName = ve.getSimpleName()) != null && veName.length() > 0) {
                            sb.append(" ");
                            sb.append(veName);
                        }
                        if (it.hasNext()) {
                            sb.append(", ");
                        }
                        paramStrings.add(sb.toString());
                    }
                    ret.add(paramStrings);
                    continue block0;
                }
                if (argTypes[i] == null || argTypes[i].getKind() != TypeKind.ERROR && !types.isAssignable(argTypes[i], param)) continue block0;
            }
        }
        return ret.isEmpty() ? null : ret;
    }
}

