/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.netbeans.api.autoupdate.UpdateElement;
import org.openide.util.NbBundle;

public class ValidationWarningPanel
extends JPanel {
    private JScrollPane spPlugins;
    private JTree tPlugins;
    private JTextArea taError;
    private JTextArea taHead;
    private JTextArea taWarning;
    private final DefaultMutableTreeNode pluginModelRoot = new DefaultMutableTreeNode("Third-party Plugins");
    private final DefaultTreeModel pluginsModel = new DefaultTreeModel(this.pluginModelRoot);

    public ValidationWarningPanel(List<UpdateElement> signedVerified, List<UpdateElement> signedUnverified, List<UpdateElement> unsigned, List<UpdateElement> modified, int total) {
        this.initComponents();
        this.tPlugins.getSelectionModel().setSelectionMode(1);
        this.taHead.setBackground(new Color(0, 0, 0, 0));
        this.taHead.setBorder(BorderFactory.createEmptyBorder());
        this.taWarning.setBackground(new Color(0, 0, 0, 0));
        this.taWarning.setBorder(BorderFactory.createEmptyBorder());
        this.taError.setVisible(!modified.isEmpty());
        this.taHead.setVisible(modified.isEmpty());
        this.postInitComponents(signedVerified, signedUnverified, unsigned, modified, total);
    }

    private void postInitComponents(List<UpdateElement> signedVerified, List<UpdateElement> signedUnverified, List<UpdateElement> unsigned, List<UpdateElement> modified, int total) {
        DefaultMutableTreeNode signedAndValidNode = new DefaultMutableTreeNode("Signed and Valid (" + signedVerified.size() + ")");
        DefaultMutableTreeNode selfSignedNode = new DefaultMutableTreeNode("Self signed (" + signedUnverified.size() + ")");
        DefaultMutableTreeNode unsignedNode = new DefaultMutableTreeNode("Unsigned (" + unsigned.size() + ")");
        DefaultMutableTreeNode modifiedNode = new DefaultMutableTreeNode("Modified/Damaged (" + modified.size() + ")");
        for (UpdateElement el : signedVerified) {
            signedAndValidNode.add(new DefaultMutableTreeNode(el.getDisplayName()));
        }
        this.pluginModelRoot.add(signedAndValidNode);
        for (UpdateElement el : signedUnverified) {
            selfSignedNode.add(new DefaultMutableTreeNode(el.getDisplayName()));
        }
        this.pluginModelRoot.add(selfSignedNode);
        for (UpdateElement el : unsigned) {
            unsignedNode.add(new DefaultMutableTreeNode(el.getDisplayName()));
        }
        this.pluginModelRoot.add(unsignedNode);
        for (UpdateElement el : modified) {
            modifiedNode.add(new DefaultMutableTreeNode(el.getDisplayName()));
        }
        this.pluginModelRoot.add(modifiedNode);
        this.pluginsModel.reload();
        int requiresAttention = signedVerified.size() + signedUnverified.size() + unsigned.size();
        if (requiresAttention > 1) {
            this.taHead.setText(NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_taHead_NotTrustedTextPl", requiresAttention, total));
        } else {
            this.taHead.setText(NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_taHead_NotTrustedTextSg", requiresAttention, total));
        }
        if (modified.size() > 0) {
            // empty if block
        }
    }

    public String getSelectedNode() {
        Object o = this.tPlugins.getLastSelectedPathComponent();
        return o == null ? "" : o.toString();
    }

    public void addSelectionListener(TreeSelectionListener tsl) {
        this.tPlugins.getSelectionModel().addTreeSelectionListener(tsl);
    }

    private void initComponents() {
        this.taHead = new JTextArea();
        this.taError = new JTextArea();
        this.spPlugins = new JScrollPane();
        this.tPlugins = new JTree();
        this.taWarning = new JTextArea();
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setMinimumSize(new Dimension(480, 400));
        this.setPreferredSize(new Dimension(480, 400));
        this.setRequestFocusEnabled(false);
        this.setLayout(new GridBagLayout());
        this.taHead.setEditable(false);
        this.taHead.setLineWrap(true);
        this.taHead.setWrapStyleWord(true);
        this.taHead.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.add((Component)this.taHead, gridBagConstraints);
        this.taHead.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_taHead_ACN"));
        this.taHead.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_taHead_ACN"));
        this.taError.setEditable(false);
        this.taError.setForeground(new Color(204, 0, 18));
        this.taError.setLineWrap(true);
        this.taError.setText(NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel.taError.text"));
        this.taError.setWrapStyleWord(true);
        this.taError.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.add((Component)this.taError, gridBagConstraints);
        this.tPlugins.setModel(this.pluginsModel);
        this.spPlugins.setViewportView(this.tPlugins);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.spPlugins, gridBagConstraints);
        this.taWarning.setEditable(false);
        this.taWarning.setLineWrap(true);
        this.taWarning.setText(NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_taWarning_Text"));
        this.taWarning.setWrapStyleWord(true);
        this.taWarning.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 512;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.taWarning, gridBagConstraints);
        this.taWarning.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_taWarning_Text_ACN"));
        this.taWarning.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_taWarning_Text_ACD"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ValidationWarningPanel.class, "ValidationWarningPanel_ACD"));
    }
}

