/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.util;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import jpt.sun.tools.javac.code.Lint;
import jpt.sun.tools.javac.code.Source;
import jpt.sun.tools.javac.util.JCDiagnostic;
import jpt.sun.tools.javac.util.Log;
import jpt30.tools.JavaFileObject;

public class MandatoryWarningHandler {
    private final Log log;
    private final Source source;
    private final boolean verbose;
    private final String prefix;
    private Set<JavaFileObject> sourcesWithReportedWarnings;
    private DeferredDiagnosticKind deferredDiagnosticKind;
    private JavaFileObject deferredDiagnosticSource;
    private Object deferredDiagnosticArg;
    private final boolean enforceMandatory;
    private final Lint.LintCategory lintCategory;

    public MandatoryWarningHandler(Log log, Source source, boolean verbose, boolean enforceMandatory, String prefix, Lint.LintCategory lc) {
        this.log = log;
        this.source = source;
        this.verbose = verbose;
        this.prefix = prefix;
        this.enforceMandatory = enforceMandatory;
        this.lintCategory = lc;
    }

    public void report(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic.Warning warnKey) {
        JavaFileObject currentSource = this.log.currentSourceFile();
        if (this.verbose) {
            if (this.sourcesWithReportedWarnings == null) {
                this.sourcesWithReportedWarnings = new HashSet<JavaFileObject>();
            }
            if (this.log.nwarnings < this.log.MaxWarnings) {
                this.logMandatoryWarning(pos, warnKey);
                this.sourcesWithReportedWarnings.add(currentSource);
            } else if (this.deferredDiagnosticKind == null) {
                this.deferredDiagnosticKind = this.sourcesWithReportedWarnings.contains(currentSource) ? DeferredDiagnosticKind.ADDITIONAL_IN_FILE : DeferredDiagnosticKind.IN_FILE;
                this.deferredDiagnosticSource = currentSource;
                this.deferredDiagnosticArg = currentSource;
            } else if (!(this.deferredDiagnosticKind != DeferredDiagnosticKind.IN_FILE && this.deferredDiagnosticKind != DeferredDiagnosticKind.ADDITIONAL_IN_FILE || Objects.equals(this.deferredDiagnosticSource, currentSource))) {
                this.deferredDiagnosticKind = DeferredDiagnosticKind.ADDITIONAL_IN_FILES;
                this.deferredDiagnosticArg = null;
            }
        } else if (this.deferredDiagnosticKind == null) {
            this.deferredDiagnosticKind = DeferredDiagnosticKind.IN_FILE;
            this.deferredDiagnosticSource = currentSource;
            this.deferredDiagnosticArg = currentSource;
        } else if (this.deferredDiagnosticKind == DeferredDiagnosticKind.IN_FILE && !Objects.equals(this.deferredDiagnosticSource, currentSource)) {
            this.deferredDiagnosticKind = DeferredDiagnosticKind.IN_FILES;
            this.deferredDiagnosticArg = null;
        }
    }

    public void reportDeferredDiagnostic() {
        if (this.deferredDiagnosticKind != null) {
            if (this.deferredDiagnosticArg == null) {
                if (this.source != null) {
                    this.logMandatoryNote(this.deferredDiagnosticSource, this.deferredDiagnosticKind.getKey(this.prefix), new Object[]{this.source});
                } else {
                    this.logMandatoryNote(this.deferredDiagnosticSource, this.deferredDiagnosticKind.getKey(this.prefix), new Object[0]);
                }
            } else if (this.source != null) {
                this.logMandatoryNote(this.deferredDiagnosticSource, this.deferredDiagnosticKind.getKey(this.prefix), new Object[]{this.deferredDiagnosticArg, this.source});
            } else {
                this.logMandatoryNote(this.deferredDiagnosticSource, this.deferredDiagnosticKind.getKey(this.prefix), this.deferredDiagnosticArg);
            }
            if (!this.verbose) {
                this.logMandatoryNote(this.deferredDiagnosticSource, this.prefix + ".recompile", new Object[0]);
            }
        }
    }

    private void logMandatoryWarning(JCDiagnostic.DiagnosticPosition pos, JCDiagnostic.Warning warnKey) {
        if (this.enforceMandatory) {
            this.log.mandatoryWarning(this.lintCategory, pos, warnKey);
        } else {
            this.log.warning(this.lintCategory, pos, warnKey);
        }
    }

    private void logMandatoryNote(JavaFileObject file, String msg, Object ... args) {
        if (this.enforceMandatory) {
            this.log.mandatoryNote(file, new JCDiagnostic.Note("compiler", msg, args));
        } else {
            this.log.note(file, new JCDiagnostic.Note("compiler", msg, args));
        }
    }

    public void clear() {
        this.sourcesWithReportedWarnings = null;
        this.deferredDiagnosticKind = null;
        this.deferredDiagnosticSource = null;
        this.deferredDiagnosticArg = null;
    }

    private static enum DeferredDiagnosticKind {
        IN_FILE(".filename"),
        ADDITIONAL_IN_FILE(".filename.additional"),
        IN_FILES(".plural"),
        ADDITIONAL_IN_FILES(".plural.additional");

        private final String value;

        private DeferredDiagnosticKind(String v) {
            this.value = v;
        }

        String getKey(String prefix) {
            return prefix + this.value;
        }
    }
}

