/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.java.project.support.ui;

import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.spi.java.project.support.ui.Bundle;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.java.project.support.ui.PackageViewChildren;
import org.netbeans.spi.search.SearchInfoDefinitionFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

final class PackageRootNode
extends AbstractNode
implements Runnable,
FileStatusListener {
    static final String PACKAGE_BADGE = "org/netbeans/spi/java/project/support/ui/packageBadge.gif";
    static final RequestProcessor PKG_VIEW_RP = new RequestProcessor(PackageRootNode.class.getName(), 1);
    private static final AtomicReference<Action[]> actions = new AtomicReference();
    private SourceGroup group;
    private final FileObject file;
    private final Set<FileObject> files;
    private FileStatusListener fileSystemListener;
    private RequestProcessor.Task task;
    private volatile boolean iconChange;
    private volatile boolean nameChange;

    PackageRootNode(SourceGroup group) {
        this(group, new PackageViewChildren(group));
    }

    private PackageRootNode(SourceGroup group, Children ch) {
        super(ch, new ProxyLookup(PackageRootNode.createLookup(group), Lookups.singleton(SearchInfoDefinitionFactory.createSearchInfoBySubnodes(ch))));
        this.group = group;
        this.file = group.getRootFolder();
        this.files = Collections.singleton(this.file);
        try {
            FileSystem fs = this.file.getFileSystem();
            this.fileSystemListener = FileUtil.weakFileStatusListener(this, fs);
            fs.addFileStatusListener(this.fileSystemListener);
        }
        catch (FileStateInvalidException e) {
            Exceptions.printStackTrace(Exceptions.attachMessage(e, "Can not get " + this.file + " filesystem, ignoring..."));
        }
        this.setName(group.getName());
        this.setDisplayName(group.getDisplayName());
    }

    @Override
    public Image getIcon(int type) {
        return this.computeIcon(false, type);
    }

    @Override
    public Image getOpenedIcon(int type) {
        return this.computeIcon(true, type);
    }

    @Override
    public String getDisplayName() {
        String s = super.getDisplayName();
        try {
            s = this.file.getFileSystem().getDecorator().annotateName(s, this.files);
        }
        catch (FileStateInvalidException e) {
            Exceptions.printStackTrace(e);
        }
        return s;
    }

    @Override
    public String getHtmlDisplayName() {
        try {
            String result = this.file.getFileSystem().getDecorator().annotateNameHtml(super.getDisplayName(), this.files);
            if (result != null && !super.getDisplayName().equals(result)) {
                return result;
            }
        }
        catch (FileStateInvalidException e) {
            Exceptions.printStackTrace(e);
        }
        return super.getHtmlDisplayName();
    }

    @Override
    public void run() {
        if (this.iconChange) {
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.iconChange = false;
        }
        if (this.nameChange) {
            this.fireDisplayNameChange(null, null);
            this.nameChange = false;
        }
    }

    @Override
    public void annotationChanged(FileStatusEvent event) {
        if (this.task == null) {
            this.task = PKG_VIEW_RP.create(this);
        }
        if ((!this.iconChange && event.isIconChange() || !this.nameChange && event.isNameChange()) && event.hasChanged(this.file)) {
            this.iconChange |= event.isIconChange();
            this.nameChange |= event.isNameChange();
        }
        this.task.schedule(50);
    }

    @Override
    @NonNull
    public Action[] getActions(boolean context) {
        Action[] res = actions.get();
        if (res == null && !actions.compareAndSet(null, res = PackageView.createRootNodeActions())) {
            res = actions.get();
        }
        assert (res != null);
        return res;
    }

    @Override
    public Node.PropertySet[] getPropertySets() {
        Node.PropertySet[] properties = this.getDataFolderNodeDelegate().getPropertySets();
        Node.PropertySet[] newProperties = Arrays.copyOf(properties, properties.length);
        for (int i = 0; i < newProperties.length; ++i) {
            if (!"properties".equals(newProperties[i].getName())) continue;
            newProperties[i] = Sheet.createPropertiesSet();
            ((Sheet.Set)newProperties[i]).put(new PropertySupport.ReadOnly<String>("name", String.class, Bundle.PROP_name(), Bundle.HINT_name()){

                @Override
                public String getValue() {
                    return PackageRootNode.this.getDisplayName();
                }
            });
            ((Sheet.Set)newProperties[i]).put(new PropertySupport.ReadOnly<String>("ROOT_PATH", String.class, Bundle.PROP_rootpath(), Bundle.HINT_rootpath()){

                @Override
                public String getValue() {
                    return FileUtil.getFileDisplayName(PackageRootNode.this.file);
                }
            });
        }
        return newProperties;
    }

    @Override
    public void createPasteTypes(Transferable t, List<PasteType> list) {
        if (t.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            try {
                MultiTransferObject mto = (MultiTransferObject)t.getTransferData(ExTransferable.multiFlavor);
                ArrayList<PackageViewChildren.PackageNode> l = new ArrayList<PackageViewChildren.PackageNode>();
                boolean isPackageFlavor = false;
                boolean hasTheSameRoot = false;
                int op = -1;
                for (int i = 0; i < mto.getCount(); ++i) {
                    Transferable pt = mto.getTransferableAt(i);
                    DataFlavor[] flavors = mto.getTransferDataFlavors(i);
                    for (int j = 0; j < flavors.length; ++j) {
                        if (!"x-java-org-netbeans-modules-java-project-packagenodednd".equals(flavors[j].getSubType()) || !"application".equals(flavors[j].getPrimaryType())) continue;
                        if (op == -1) {
                            op = Integer.valueOf(flavors[j].getParameter("mask"));
                        }
                        PackageViewChildren.PackageNode pkgNode = (PackageViewChildren.PackageNode)pt.getTransferData(flavors[j]);
                        if (!((PackageViewChildren)this.getChildren()).getRoot().equals(pkgNode.getRoot())) {
                            l.add(pkgNode);
                        } else {
                            hasTheSameRoot = true;
                        }
                        isPackageFlavor = true;
                    }
                }
                if (isPackageFlavor && !hasTheSameRoot) {
                    list.add(new PackageViewChildren.PackagePasteType(this.group.getRootFolder(), l.toArray(new PackageViewChildren.PackageNode[0]), op));
                } else if (!isPackageFlavor) {
                    list.addAll(Arrays.asList(this.getDataFolderNodeDelegate().getPasteTypes(t)));
                }
            }
            catch (UnsupportedFlavorException e) {
                Exceptions.printStackTrace(e);
            }
            catch (IOException e) {
                Exceptions.printStackTrace(e);
            }
        } else {
            DataFlavor[] flavors = t.getTransferDataFlavors();
            FileObject root = this.group.getRootFolder();
            boolean isPackageFlavor = false;
            if (root != null && root.canWrite()) {
                for (DataFlavor flavor : flavors) {
                    if (!"x-java-org-netbeans-modules-java-project-packagenodednd".equals(flavor.getSubType()) || !"application".equals(flavor.getPrimaryType())) continue;
                    isPackageFlavor = true;
                    try {
                        int op = Integer.parseInt(flavor.getParameter("mask"));
                        PackageViewChildren.PackageNode pkgNode = (PackageViewChildren.PackageNode)t.getTransferData(flavor);
                        if (((PackageViewChildren)this.getChildren()).getRoot().equals(pkgNode.getRoot())) continue;
                        list.add(new PackageViewChildren.PackagePasteType(root, new PackageViewChildren.PackageNode[]{pkgNode}, op));
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace(ioe);
                    }
                    catch (UnsupportedFlavorException ufe) {
                        Exceptions.printStackTrace(ufe);
                    }
                }
            }
            if (!isPackageFlavor) {
                list.addAll(Arrays.asList(this.getDataFolderNodeDelegate().getPasteTypes(t)));
            }
        }
    }

    @Override
    public PasteType getDropType(Transferable t, int action, int index) {
        PasteType pasteType = super.getDropType(t, action, index);
        if (pasteType instanceof PackageViewChildren.PackagePasteType) {
            ((PackageViewChildren.PackagePasteType)pasteType).setOperation(action);
        }
        return pasteType;
    }

    private Node getDataFolderNodeDelegate() {
        block3: {
            DataFolder df = this.getLookup().lookup(DataFolder.class);
            try {
                if (df.isValid()) {
                    return df.getNodeDelegate();
                }
            }
            catch (IllegalStateException e) {
                if (!df.isValid()) break block3;
                throw e;
            }
        }
        return new AbstractNode(Children.LEAF);
    }

    private Image computeIcon(boolean opened, int type) {
        Image image;
        Icon icon = this.group.getIcon(opened);
        if (icon == null) {
            image = opened ? this.getDataFolderNodeDelegate().getOpenedIcon(type) : this.getDataFolderNodeDelegate().getIcon(type);
            image = ImageUtilities.mergeImages(image, ImageUtilities.loadImage(PACKAGE_BADGE), 7, 7);
        } else {
            image = ImageUtilities.icon2Image(icon);
        }
        return image;
    }

    private static Lookup createLookup(SourceGroup group) {
        FileObject rootFolder = group.getRootFolder();
        DataFolder dataFolder = DataFolder.findFolder(rootFolder);
        return Lookups.fixed(dataFolder, new PathFinder(group));
    }

    public static class PathFinder
    implements org.netbeans.spi.project.ui.PathFinder {
        private SourceGroup group;

        public PathFinder(SourceGroup group) {
            this.group = group;
        }

        @Override
        public Node findPath(Node root, Object object) {
            FileObject fo;
            if (object instanceof FileObject) {
                fo = (FileObject)object;
            } else if (object instanceof DataObject) {
                fo = ((DataObject)object).getPrimaryFile();
            } else {
                return null;
            }
            FileObject groupRoot = this.group.getRootFolder();
            if (FileUtil.isParentOf(groupRoot, fo)) {
                String relPath = FileUtil.getRelativePath(groupRoot, fo.isFolder() ? fo : fo.getParent());
                String[] path = new String[]{relPath.replace('/', '.')};
                try {
                    Node packageNode = NodeOp.findPath(root, path);
                    if (fo.isFolder()) {
                        return packageNode;
                    }
                    for (Node child : packageNode.getChildren().getNodes(true)) {
                        DataObject dobj = child.getLookup().lookup(DataObject.class);
                        if (dobj == null || !dobj.getPrimaryFile().getNameExt().equals(fo.getNameExt())) continue;
                        return child;
                    }
                }
                catch (NodeNotFoundException e) {
                    return null;
                }
            } else if (groupRoot.equals(fo)) {
                try {
                    return NodeOp.findPath(root, new String[]{""});
                }
                catch (NodeNotFoundException nodeNotFoundException) {
                    return root;
                }
            }
            return null;
        }

        public String toString() {
            return "PathFinder[" + this.group + "]";
        }
    }
}

