/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package net.java.html.boot.script.impl;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public final class PromisePolyfill {
    private PromisePolyfill() {
    }

    public static void initialize(ScriptEngine eng, Executor pool) {
        try ( InputStreamReader r = new InputStreamReader(
            PromisePolyfill.class.getResourceAsStream("promisePolyfill.js"))
        ) {
            if ("undefined".equals(eng.eval("typeof Promise"))) {
                Object fn = eng.eval(r);
                ((Invocable) eng).invokeMethod(fn, "call", null, PromisePolyfill.class);
            }
        } catch (IOException | NoSuchMethodException | ScriptException ex) {
            throw new IllegalStateException("Cannot install Promise polyfill into Nashorn", ex);
        }

    }

    public static boolean isFuture(Object obj) {
        return obj instanceof CompletableFuture;
    }

    public static <T> CompletableFuture<T> create() {
        CompletableFuture<T> future = new CompletableFuture<>();
        return future;
    }
}
