/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.cdi;

import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.spi.InjectionProvider;
import org.apache.myfaces.spi.InjectionProviderException;

import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.faces.context.ExternalContext;

/**
 *
 * @author Leonardo Uribe
 */
public class CDIInjectionProviderImpl extends InjectionProvider
{
    private BeanManager beanManager;

    public CDIInjectionProviderImpl(ExternalContext externalContext)
    {
        beanManager = CDIUtils.getBeanManager(externalContext);
    }

    @Override
    public Object inject(Object instance) throws InjectionProviderException
    {
        AnnotatedType annoType = beanManager.createAnnotatedType(instance.getClass());
        InjectionTarget target = beanManager.createInjectionTarget(annoType);
        CreationalContext<?> creationalContext =  beanManager.createCreationalContext(null);

        target.inject(instance, creationalContext);

        return creationalContext;
    }

    @Override
    public void postConstruct(Object instance, Object creationMetaData) throws InjectionProviderException
    {
        AnnotatedType annoType = beanManager.createAnnotatedType(instance.getClass());
        InjectionTarget target = beanManager.createInjectionTarget(annoType);
        target.postConstruct(instance);
    }

    @Override
    public void preDestroy(Object instance, Object creationMetaData) throws InjectionProviderException
    {
        if (creationMetaData instanceof CreationalContext)
        {
            AnnotatedType annoType = beanManager.createAnnotatedType(instance.getClass());
            InjectionTarget target = beanManager.createInjectionTarget(annoType);
            target.preDestroy(instance);

            ((CreationalContext)creationMetaData).release();
        }
    }
}
