/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderingContext;
import org.apache.myfaces.trinidadinternal.share.url.URLEncoder;
import org.apache.myfaces.trinidadinternal.ui.UINode;
import org.apache.myfaces.trinidadinternal.ui.UIXRenderingContext;
import org.apache.myfaces.trinidadinternal.ui.action.ClientAction;
import org.apache.myfaces.trinidadinternal.ui.action.ClientActionUtils;
import org.apache.myfaces.trinidadinternal.ui.action.FireAction;
import org.apache.myfaces.trinidadinternal.ui.collection.Parameter;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.HiddenLabelUtils;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.LinkDataObject;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.LinkUtils;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafConstants;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafRenderer;
import org.apache.myfaces.trinidadinternal.ui.laf.base.xhtml.XhtmlLafUtils;

@Deprecated
public class LinkRenderer
extends XhtmlLafRenderer {
    private static final Object _SAVE_MODEL_DISABLED_KEY = new Object();
    private static final Object _NONE = new Object();
    private static final Object _LOCAL_ON_CLICK_KEY = new Object();
    private static final Object _LOCAL_PARTIAL_TARGETS_KEY = new Object();
    private static final String _STATUS_SELECTED_KEY = "STATUS_SELECTED";

    @Override
    public void render(UIXRenderingContext context, UINode node) throws IOException {
        if (LinkDataObject.__isDataObjectUsedMode(context)) {
            this._buildDataObject(context, node);
        } else {
            super.render(context, node);
        }
    }

    private String _addParams(UIXRenderingContext context, UINode node, ClientAction action, String dest) throws IOException {
        Parameter[] params;
        String rv = dest;
        if (action != null && (params = action.getParameters(context, node)) != null) {
            rv = ClientActionUtils.appendURLParameters(context, dest, params);
        }
        return rv;
    }

    @Override
    protected void renderAttributes(UIXRenderingContext context, UINode node) throws IOException {
        super.renderAttributes(context, node);
        if (!this.isDisabled(context, node) && LinkRenderer.supportsNavigation(context)) {
            Object id;
            ClientAction action;
            String destination = this.getDestination(context, node);
            if (destination != null && (action = ClientActionUtils.getPrimaryClientAction(context, node)) != null && !action.renderAsEvent(context, node) && !"#".equals(destination)) {
                destination = this._addParams(context, node, action, destination);
            }
            if (this._isAnchor(destination, id = this.getID(context, node))) {
                this.renderDestination(context, node, destination);
                if (LinkRenderer.supportsAccessKeys(context)) {
                    this.renderAttribute(context, node, "accesskey", ACCESS_KEY_ATTR);
                }
            }
        }
    }

    @Override
    protected boolean isDisabled(UIXRenderingContext context, UINode node) {
        RenderingContext arc = RenderingContext.getCurrentInstance();
        boolean isDisabled = ((CoreRenderingContext)arc).isLinkDisabled();
        boolean disabledAttr = XhtmlLafUtils.getLocalBooleanAttribute(context, node, DISABLED_ATTR, false);
        boolean readOnlyAttr = XhtmlLafUtils.getLocalBooleanAttribute(context, node, READ_ONLY_ATTR, false);
        return isDisabled ? true : disabledAttr || readOnlyAttr;
    }

    public static void setDisabled(UIXRenderingContext context, boolean isDisabled) {
        RenderingContext arc = RenderingContext.getCurrentInstance();
        ((CoreRenderingContext)arc).setLinkDisabled(isDisabled);
    }

    public static void setSaveModelDisabled(UIXRenderingContext context, boolean isDisabled) {
    }

    protected boolean isSaveModelDisabled(UIXRenderingContext context) {
        return LinkRenderer.getRenderingProperty(context, _SAVE_MODEL_DISABLED_KEY) != null;
    }

    protected void renderDestination(UIXRenderingContext context, UINode node, String destination) throws IOException {
        if (destination != null) {
            boolean isJavascript = destination.startsWith("javascript:");
            if (!isJavascript && !destination.startsWith("#") && this.isSaveModelDisabled(context)) {
                destination = LinkRenderer.appendURLArgument(destination, "_noSv", "M");
            }
            if (!isJavascript || LinkRenderer.supportsScripting(context)) {
                this.renderEncodedActionURI(context, "href", destination);
            }
        }
        if (LinkRenderer.supportsTarget(context)) {
            this.renderAttribute(context, "target", this.getTargetFrame(context, node));
        }
    }

    @Override
    protected void renderEventHandlers(UIXRenderingContext context, UINode node) throws IOException {
        if (!this.isDisabled(context, node)) {
            super.renderEventHandlers(context, node);
            this.renderAttribute(context, node, "onblur", ON_BLUR_ATTR);
            this.renderAttribute(context, node, "onfocus", ON_FOCUS_ATTR);
        }
    }

    @Override
    protected void renderID(UIXRenderingContext context, UINode node) throws IOException {
        Object id = this.getID(context, node);
        if (id != null) {
            if (LinkRenderer.supportsID(context)) {
                this.renderURIID(context, id);
            }
            if (LinkRenderer.supportsNameIdentification(context) && this.makeNameAndIDSame(context)) {
                this.renderURIAttribute(context, "name", id);
            }
        }
    }

    protected boolean makeNameAndIDSame(UIXRenderingContext context) {
        return true;
    }

    @Override
    protected Object getID(UIXRenderingContext context, UINode node) {
        if (this.makeNameAndIDSame(context)) {
            return this.getCachedIDOrName(context, node);
        }
        return XhtmlLafUtils.getLocalAttribute(context, node, ID_ATTR);
    }

    protected String getDestination(UIXRenderingContext context, UINode node) {
        String destination = this.getDestinationAttr(context, node);
        if (destination == null) {
            Object onClick;
            if (LinkRenderer.supportsIntrinsicEvents(context) && (onClick = this.getOnClick(context, node)) != null) {
                destination = "#";
            }
        } else if (LinkRenderer.getAncestorPartialTargets(context) != null) {
            destination = "#";
        }
        return destination;
    }

    protected final String getDestinationAttr(UIXRenderingContext context, UINode node) {
        return XhtmlLafUtils.getLocalTextAttribute(context, node, DESTINATION_ATTR);
    }

    @Override
    protected Object getText(UIXRenderingContext context, UINode node) {
        return XhtmlLafUtils.getLocalTextAttribute(context, node, TEXT_ATTR);
    }

    protected Object getTargetFrame(UIXRenderingContext context, UINode node) {
        return node.getAttributeValue(context, TARGET_FRAME_ATTR);
    }

    @Override
    protected Object getStyleClass(UIXRenderingContext context, UINode node) {
        String nodeStyleClass = (String)node.getAttributeValue(context, STYLE_CLASS_ATTR);
        if (nodeStyleClass != null) {
            return nodeStyleClass;
        }
        String styleClass = null;
        if (!LinkUtils.isDefaultStyleClassDisabled(context)) {
            styleClass = this.isDisabled(context, node) ? "OraLinkDisabled" : "OraLink";
        }
        return styleClass;
    }

    @Override
    protected void prerender(UIXRenderingContext context, UINode node) throws IOException {
        boolean isDisabled;
        if (this.isEmpty(context, node)) {
            return;
        }
        ClientAction action = ClientActionUtils.getPrimaryClientAction(context, node);
        if (action != null) {
            action.writeDependencies(context, node);
        }
        super.prerender(context, node);
        Object styleClass = this.getStyleClass(context, node);
        if (styleClass == null && (isDisabled = this.isDisabled(context, node))) {
            styleClass = "p_OraDisabled";
        }
        Object inlineStyle = this.getInlineStyle(context, node);
        boolean supportsStyleAttributes = LinkRenderer.supportsStyleAttributes(context);
        if (supportsStyleAttributes) {
            LinkRenderer.renderStyleClassAttribute(context, styleClass);
            LinkRenderer.renderInlineStyleAttribute(context, inlineStyle);
        } else if (LinkRenderer.supportsTextPresentation(context)) {
            this.startRenderingStyleElements(context, null, styleClass);
        }
    }

    @Override
    protected void postrender(UIXRenderingContext context, UINode node) throws IOException {
        if (this.isEmpty(context, node)) {
            return;
        }
        boolean supportsStyleAttributes = LinkRenderer.supportsStyleAttributes(context);
        if (!supportsStyleAttributes && LinkRenderer.supportsTextPresentation(context)) {
            XhtmlLafUtils.endRenderingStyleElements(context);
        }
        super.postrender(context, node);
    }

    @Override
    protected void renderContent(UIXRenderingContext context, UINode node) throws IOException {
        if (this.isEmpty(context, node)) {
            return;
        }
        if (!LinkRenderer.isInaccessibleMode(context)) {
            this._renderAccessibleStatus(context);
        }
        if (this._isAnchor(context, node)) {
            this.renderAccessKeyText(context, node, this.getText(context, node), "AFLinkAccessKeyStyle");
        } else {
            this.renderText(context, node);
        }
        super.renderContent(context, node);
    }

    @Override
    protected boolean doRenderStyleAttrs(UIXRenderingContext context, UINode node) {
        return false;
    }

    @Override
    protected String getElementName(UIXRenderingContext context, UINode node) {
        Object id;
        int childCount;
        Object text = this.getText(context, node);
        if (this._isEmpty(text, childCount = node.getIndexedChildCount(context), id = this.getID(context, node))) {
            return null;
        }
        String destination = this.getDestination(context, node);
        return this._isAnchor(destination, id) ? "a" : "span";
    }

    @Override
    protected Object getOnClick(UIXRenderingContext context, UINode node) {
        UIComponent component;
        Object prop = context.getLocalProperty(0, _LOCAL_ON_CLICK_KEY, _NONE);
        if (prop != _NONE) {
            return prop;
        }
        Object onClick = super.getOnClick(context, node);
        ClientAction action = ClientActionUtils.getPrimaryClientAction(context, node);
        String actionScript = null;
        if (action instanceof FireAction && (component = node.getUIComponent()) != null && Boolean.TRUE.equals(component.getAttributes().get("blocking"))) {
            ((FireAction)action).setBlocking(true);
        }
        if (action != null) {
            if (action.renderAsEvent(context, node) && this.getDestinationAttr(context, node) == null) {
                actionScript = action.getScript(context, node, Boolean.FALSE);
            }
        } else {
            actionScript = this.getPartialChangeScript(context, node);
        }
        Object chainedScript = null;
        if (onClick != null || actionScript != null) {
            chainedScript = XhtmlLafUtils.getChainedJS(onClick, actionScript, true);
        }
        context.setLocalProperty(_LOCAL_ON_CLICK_KEY, chainedScript);
        return chainedScript;
    }

    protected String getPartialChangeScript(UIXRenderingContext context, UINode node) {
        String partialTargets = LinkRenderer.getAncestorPartialTargets(context);
        if (partialTargets == null) {
            return null;
        }
        String destination = this.getDestinationAttr(context, node);
        if (destination == null) {
            return null;
        }
        URLEncoder encoder = context.getURLEncoder();
        String partialTargetsKey = encoder.encodeParameter("partialTargets");
        destination = XhtmlLafUtils.appendURLArgument(destination, partialTargetsKey, partialTargets);
        return XhtmlLafUtils.getFirePartialChangeHandler(destination);
    }

    protected static String getAncestorPartialTargets(UIXRenderingContext context) {
        Object prop = context.getLocalProperty(0, _LOCAL_PARTIAL_TARGETS_KEY, _NONE);
        if (prop != _NONE) {
            return (String)prop;
        }
        String partialTargets = (String)context.getProperty("http://myfaces.apache.org/uix/ui", XhtmlLafConstants.LINK_CONTAINER_PARTIAL_TARGETS_PROPERTY);
        context.setLocalProperty(_LOCAL_PARTIAL_TARGETS_KEY, partialTargets);
        return partialTargets;
    }

    private boolean _isAnchor(UIXRenderingContext context, UINode node) {
        return this._isAnchor(this.getDestination(context, node), this.getID(context, node));
    }

    private boolean _isAnchor(String destination, Object id) {
        return destination != null || id != null;
    }

    protected boolean isEmpty(UIXRenderingContext context, UINode node) {
        return this._isEmpty(this.getText(context, node), node.getIndexedChildCount(context), this.getID(context, node));
    }

    private boolean _isEmpty(Object text, int childCount, Object id) {
        return text == null && childCount <= 0 && id == null;
    }

    private void _buildDataObject(UIXRenderingContext context, UINode link) throws IOException {
        Object id = this.getID(context, link);
        String destination = this.getDestination(context, link);
        Object text = this.getText(context, link);
        Object onClick = this.getOnClick(context, link);
        Object target = this.getTargetFrame(context, link);
        Object shortDesc = this.getShortDesc(context, link);
        Object accessKey = link.getAttributeValue(context, ACCESS_KEY_ATTR);
        Integer currentIndex = LinkDataObject.__getCurrentIndex(context);
        boolean isSelected = Boolean.TRUE.equals(link.getAttributeValue(context, SELECTED_ATTR));
        boolean isDisabled = this.isDisabled(context, link);
        LinkDataObject dobj = new LinkDataObject(id, text, shortDesc, destination, onClick, target, accessKey, isSelected, isDisabled, currentIndex, link);
        LinkDataObject.__setDataObject(context, dobj);
    }

    private void _renderAccessibleStatus(UIXRenderingContext context) throws IOException {
        if (!HiddenLabelUtils.supportsHiddenLabels(context)) {
            return;
        }
        boolean isSelected = LinkUtils.isSelected(context);
        if (isSelected) {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("span", null);
            LinkRenderer.renderStyleClassAttribute(context, "p_OraHiddenLabel");
            Object spanText = LinkRenderer.getTranslatedValue(context, _STATUS_SELECTED_KEY);
            writer.writeText(spanText, null);
            writer.endElement("span");
        }
    }
}

