/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.image.painter;

import org.apache.myfaces.trinidadinternal.image.painter.AbstractBorderPainter;
import org.apache.myfaces.trinidadinternal.image.painter.ImmInsets;
import org.apache.myfaces.trinidadinternal.image.painter.PaintContext;
import org.apache.myfaces.trinidadinternal.image.painter.Painter;
import org.apache.myfaces.trinidadinternal.style.CoreStyle;
import org.apache.myfaces.trinidadinternal.style.PropertyParseException;
import org.apache.myfaces.trinidadinternal.style.util.CSSUtils;

public class AdjustableBorderPainter
extends AbstractBorderPainter {
    private ImmInsets _defaultInsets;
    private String _styleNamePrefix;
    private static final String _TOP_PADDING = "padding-top";
    private static final String _LEFT_PADDING = "padding-left";
    private static final String _BOTTOM_PADDING = "padding-bottom";
    private static final String _RIGHT_PADDING = "padding-right";

    public AdjustableBorderPainter(Painter wrappedPainter, int top, int left, int bottom, int right, String styleNamePrefix) {
        super(wrappedPainter);
        this._defaultInsets = new ImmInsets(top, left, bottom, right);
        this._styleNamePrefix = styleNamePrefix;
    }

    protected ImmInsets getOwnInsets(PaintContext context) {
        int top = this._defaultInsets.top;
        int left = this._defaultInsets.left;
        int bottom = this._defaultInsets.bottom;
        int right = this._defaultInsets.right;
        CoreStyle style = this._getPaddingStyle(context);
        if (style != null) {
            top = AdjustableBorderPainter._getPadding(style, _TOP_PADDING, top);
            left = AdjustableBorderPainter._getPadding(style, _LEFT_PADDING, left);
            bottom = AdjustableBorderPainter._getPadding(style, _BOTTOM_PADDING, bottom);
            right = AdjustableBorderPainter._getPadding(style, _RIGHT_PADDING, right);
        }
        if (context.getReadingDirection() == 2) {
            return new ImmInsets(top, right, bottom, left);
        }
        return new ImmInsets(top, left, bottom, right);
    }

    private CoreStyle _getPaddingStyle(PaintContext context) {
        return null;
    }

    private static int _getPadding(CoreStyle style, String propertyName, int defaultValue) {
        String value;
        if (style != null && (value = (String)style.getProperties().get(propertyName)) != null) {
            Integer parsedValue = null;
            try {
                parsedValue = CSSUtils.parseLength(value);
            }
            catch (PropertyParseException propertyParseException) {
                // empty catch block
            }
            if (parsedValue != null) {
                return parsedValue;
            }
        }
        return defaultValue;
    }
}

