/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.resource;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.myfaces.trinidad.resource.ResourceLoader;
import org.apache.myfaces.trinidad.util.URLUtils;

public class CachingResourceLoader
extends ResourceLoader {
    private final ConcurrentMap<String, URL> _cache = new ConcurrentHashMap<String, URL>();

    public CachingResourceLoader(ResourceLoader parent) {
        super(parent);
    }

    @Override
    protected URL findResource(String path) throws IOException {
        URL url = (URL)this._cache.get(path);
        if (url == null && (url = this.getParent().getResource(path)) != null) {
            url = new URL("cache", null, -1, path, new URLStreamHandlerImpl(url));
            this._cache.putIfAbsent(path, url);
        }
        return url;
    }

    @Override
    public boolean isCachable() {
        return false;
    }

    private static class URLConnectionImpl
    extends URLConnection {
        private final URLConnection _conn;
        private final URLStreamHandlerImpl _handler;

        public URLConnectionImpl(URL url, URLConnection conn, URLStreamHandlerImpl handler) {
            super(url);
            this._conn = conn;
            this._handler = handler;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public String getContentType() {
            return this._conn.getContentType();
        }

        @Override
        public int getContentLength() {
            return this._conn.getContentLength();
        }

        @Override
        public long getLastModified() {
            try {
                return URLUtils.getLastModified(this._conn);
            }
            catch (IOException exception) {
                return -1L;
            }
        }

        @Override
        public String getHeaderField(String name) {
            return this._conn.getHeaderField(name);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this._handler.getInputStream(this._conn);
        }
    }

    private static class URLStreamHandlerImpl
    extends URLStreamHandler {
        private final URL _delegate;
        private byte[] _contents;
        private long _contentsModified;

        public URLStreamHandlerImpl(URL delegate) {
            this._delegate = delegate;
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            return new URLConnectionImpl(url, this._delegate.openConnection(), this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected InputStream getInputStream(URLConnection conn) throws IOException {
            long lastModified = URLUtils.getLastModified(this._delegate);
            if (this._contents == null || this._contentsModified < lastModified) {
                InputStream in = conn.getInputStream();
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    int length;
                    byte[] buffer = new byte[2048];
                    while ((length = in.read(buffer)) >= 0) {
                        out.write(buffer, 0, length);
                    }
                }
                finally {
                    in.close();
                }
                this._contents = out.toByteArray();
                this._contentsModified = URLUtils.getLastModified(conn);
            }
            return new ByteArrayInputStream(this._contents);
        }
    }
}

