/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.model;

import java.beans.IntrospectionException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.el.PropertyResolver;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.model.BaseMenuModel;
import org.apache.myfaces.trinidad.model.TreeModel;

public class ViewIdPropertyMenuModel
extends BaseMenuModel {
    private final Map<Object, Object> _focusPathMap = new HashMap<Object, Object>();
    private String _viewIdProperty = null;
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ViewIdPropertyMenuModel.class);

    public ViewIdPropertyMenuModel() {
    }

    public ViewIdPropertyMenuModel(Object instance, String viewIdProperty) throws IntrospectionException {
        super(instance);
        this.setViewIdProperty(viewIdProperty);
        this.setWrappedData(instance);
    }

    @Override
    public void setWrappedData(Object data) {
        super.setWrappedData(data);
        Object oldPath = this.getRowKey();
        this._focusPathMap.clear();
        this.setRowKey(null);
        FacesContext context = FacesContext.getCurrentInstance();
        ViewIdPropertyMenuModel._addToMap(context, this, this._focusPathMap, this.getViewIdProperty());
        this.setRowKey(oldPath);
    }

    @Override
    public Object getFocusRowKey() {
        String currentViewId = this.getCurrentViewId();
        Object focusPath = this._focusPathMap.get(currentViewId);
        return focusPath;
    }

    public void addViewId(String newViewId, String aliasedViewId) {
        Object focusPath = this._focusPathMap.get(aliasedViewId);
        if (focusPath != null) {
            this._focusPathMap.put(newViewId, focusPath);
        }
    }

    public String getViewIdProperty() {
        return this._viewIdProperty;
    }

    public void setViewIdProperty(String viewIdProperty) {
        this._viewIdProperty = viewIdProperty;
    }

    protected String getCurrentViewId() {
        String currentViewId = FacesContext.getCurrentInstance().getViewRoot().getViewId();
        return currentViewId;
    }

    private static void _addToMap(FacesContext context, TreeModel tree, Map<Object, Object> focusPathMap, String viewIdProperty) {
        for (int i = 0; i < tree.getRowCount(); ++i) {
            tree.setRowIndex(i);
            if (viewIdProperty != null) {
                Object focusPath = tree.getRowKey();
                Object data = tree.getRowData();
                PropertyResolver resolver = context.getApplication().getPropertyResolver();
                Object viewIdObject = resolver.getValue(data, (Object)viewIdProperty);
                focusPathMap.put(viewIdObject, focusPath);
            } else {
                _LOG.warning("NULL_VIEWID");
            }
            if (!tree.isContainer() || tree.isContainerEmpty()) continue;
            tree.enterContainer();
            ViewIdPropertyMenuModel._addToMap(context, tree, focusPathMap, viewIdProperty);
            tree.exitContainer();
        }
    }
}

