/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.LibraryScriptlet;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.jsLibs.Scriptlet;

public class AliasedScriptlet
extends Scriptlet {
    private final String _name;
    private final Object[] _functions;
    private final Object[] _dependencies;
    private final Object _actualLibrary;
    private static final Properties _ALIASES = new Properties();
    private static final String _JAVASCRIPT_ALIAS_FILE = "javascriptmap.properties";
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(AliasedScriptlet.class);

    public static void registerAliases() {
        HashSet<String> aliases = new HashSet<String>();
        Enumeration<?> names = _ALIASES.propertyNames();
        while (names.hasMoreElements()) {
            aliases.add(_ALIASES.getProperty((String)names.nextElement()));
        }
        for (String libName : aliases) {
            LibraryScriptlet scriptlet = null;
            scriptlet = "Common".equals(libName) ? new LibraryScriptlet(libName, null){

                @Override
                boolean __isOutsidePartialPage(RenderingContext arc) {
                    return false;
                }
            } : new LibraryScriptlet(libName, null);
            ((Scriptlet)scriptlet).registerSelf();
        }
    }

    public AliasedScriptlet(String name, Object[] functions) {
        this(name, functions, null);
    }

    public AliasedScriptlet(String name, Object[] functions, Object[] dependencies) {
        this._name = name;
        this._functions = functions == null ? null : (Object[])functions.clone();
        this._dependencies = dependencies == null ? null : (Object[])dependencies.clone();
        this._actualLibrary = AliasedScriptlet._getAlias(name);
    }

    @Override
    public Object getScriptletKey() {
        return this._name;
    }

    @Override
    public void registerSelf() {
        super.registerSelf();
        if (this._functions != null) {
            for (int i = 0; i < this._functions.length; ++i) {
                this.registerSelfWithKey(this._functions[i]);
            }
        }
    }

    @Override
    protected void outputScriptletImpl(FacesContext context, RenderingContext arc) throws IOException {
        if (this._dependencies != null) {
            for (int i = 0; i < this._dependencies.length; ++i) {
                this.outputDependency(context, arc, this._dependencies[i]);
            }
        }
        this.outputDependency(context, arc, this._actualLibrary);
    }

    @Override
    protected void outputScriptletContent(FacesContext context, RenderingContext arc) throws IOException {
    }

    private static String _getAlias(String theLibraryName) {
        return _ALIASES.getProperty(theLibraryName, theLibraryName);
    }

    static {
        Class<AliasedScriptlet> cl = AliasedScriptlet.class;
        InputStream in = cl.getResourceAsStream(_JAVASCRIPT_ALIAS_FILE);
        if (in == null) {
            _LOG.severe("UNABLE_GET_RESOURCE", (Object)_JAVASCRIPT_ALIAS_FILE);
            throw new AssertionError();
        }
        try {
            _ALIASES.load(in);
            in.close();
        }
        catch (IOException ioException) {
            throw new AssertionError((Object)ioException);
        }
    }
}

