/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.layout.CorePanelGroupLayout;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.OutputUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class PanelGroupLayoutRenderer
extends XhtmlRenderer {
    private PropertyKey _layoutKey;

    public PanelGroupLayoutRenderer() {
        this(CorePanelGroupLayout.TYPE);
    }

    protected PanelGroupLayoutRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._layoutKey = type.findKey("layout");
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected String getDefaultStyleClass(UIComponent component, FacesBean bean) {
        return "af|panelGroupLayout";
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        Object layout = this.getLayout(component, bean);
        boolean isVertical = "vertical".equals(layout);
        boolean isHorizontal = "horizontal".equals(layout);
        if (isHorizontal) {
            rw.startElement("table", component);
            OutputUtils.renderLayoutTableAttributes(context, rc, "0", null);
        } else if (isVertical) {
            rw.startElement("div", component);
        } else {
            rw.startElement("span", component);
        }
        this.renderId(context, component);
        this.renderAllAttributes(context, rc, component, bean);
        if (isHorizontal) {
            rw.startElement("tr", null);
        }
        this._encodeChildren(context, component, isVertical, isHorizontal);
        if (isHorizontal) {
            rw.endElement("tr");
            rw.endElement("table");
        } else if (isVertical) {
            rw.endElement("div");
        } else {
            rw.endElement("span");
        }
    }

    private void _encodeChildren(FacesContext context, UIComponent component, boolean isVertical, boolean isHorizontal) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        UIComponent separator = PanelGroupLayoutRenderer.getFacet((UIComponent)component, (String)"separator");
        boolean needSeparator = false;
        for (UIComponent child : component.getChildren()) {
            if (!child.isRendered()) continue;
            if (needSeparator) {
                if (isVertical) {
                    rw.startElement("div", null);
                }
                this.encodeSeparator(context, separator, isHorizontal);
                if (isVertical) {
                    rw.endElement("div");
                }
            }
            this.encodeChild(context, child, isHorizontal);
            needSeparator = true;
        }
    }

    protected void encodeSeparator(FacesContext context, UIComponent separator, boolean isHorizontal) throws IOException {
        if (separator != null) {
            this.encodeChild(context, separator, isHorizontal);
        }
    }

    protected void encodeChild(FacesContext context, UIComponent child, boolean isHorizontal) throws IOException {
        if (isHorizontal) {
            ResponseWriter rw = context.getResponseWriter();
            rw.startElement("td", null);
            this.encodeChild(context, child);
            rw.endElement("td");
        } else {
            this.encodeChild(context, child);
        }
    }

    protected Object getLayout(UIComponent component, FacesBean bean) {
        return bean.getProperty(this._layoutKey);
    }
}

