/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.core.xhtml;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.core.nav.CoreGoLink;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.renderkit.core.CoreRenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.AccessKeyUtils;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlUtils;

public class GoLinkRenderer
extends XhtmlRenderer {
    private PropertyKey _accessKeyKey;
    private PropertyKey _destinationKey;
    private PropertyKey _disabledKey;
    private PropertyKey _onblurKey;
    private PropertyKey _onfocusKey;
    private PropertyKey _targetFrameKey;
    private PropertyKey _textKey;

    public GoLinkRenderer() {
        this(CoreGoLink.TYPE);
    }

    protected GoLinkRenderer(FacesBean.Type type) {
        super(type);
    }

    @Override
    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._accessKeyKey = type.findKey("accessKey");
        this._destinationKey = type.findKey("destination");
        this._disabledKey = type.findKey("disabled");
        this._onblurKey = type.findKey("onblur");
        this._onfocusKey = type.findKey("onfocus");
        this._targetFrameKey = type.findKey("targetFrame");
        this._textKey = type.findKey("text");
    }

    protected void encodeBegin(FacesContext context, RenderingContext rc, UIComponent comp, FacesBean bean) throws IOException {
        char accessKey;
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("a", comp);
        if (this.getDisabled(comp, bean) || !GoLinkRenderer.supportsNavigation(rc)) {
            this.renderId(context, comp);
            this.renderStyleAttributes(context, rc, comp, bean);
        } else {
            this.renderId(context, comp);
            this.renderAllAttributes(context, rc, comp, bean);
            String destination = this.getDestination(comp, bean);
            if (destination == null && this.hasOnclick(comp, bean)) {
                destination = "#";
            }
            this.renderEncodedActionURI(context, "href", destination);
            if (!Boolean.FALSE.equals(rc.getAgent().getCapabilities().get(TrinidadAgent.CAP_TARGET))) {
                rw.writeAttribute("target", (Object)this.getTargetFrame(comp, bean), null);
            }
        }
        if (GoLinkRenderer.supportsAccessKeys(rc)) {
            accessKey = this.getAccessKey(comp, bean);
            if (accessKey != '\uffff') {
                rw.writeAttribute("accesskey", (Object)Character.valueOf(accessKey), "accessKey");
            }
        } else {
            accessKey = '\uffff';
        }
        AccessKeyUtils.renderAccessKeyText(context, (Object)this.getText(comp, bean), accessKey, "AFLinkAccessKeyStyle");
    }

    public void encodeEnd(FacesContext context, RenderingContext rc, UIComponent comp, FacesBean bean) throws IOException {
        ResponseWriter rw = context.getResponseWriter();
        rw.endElement("a");
    }

    protected void renderId(FacesContext context, UIComponent component) throws IOException {
        if (this.shouldRenderId(context, component)) {
            String clientId = this.getClientId(context, component);
            context.getResponseWriter().writeURIAttribute("id", (Object)clientId, "id");
            context.getResponseWriter().writeURIAttribute("name", (Object)clientId, "id");
        }
    }

    @Override
    protected void renderEventHandlers(FacesContext context, UIComponent component, FacesBean bean) throws IOException {
        super.renderEventHandlers(context, component, bean);
        ResponseWriter rw = context.getResponseWriter();
        rw.writeAttribute("onblur", (Object)this.getOnblur(component, bean), "onblur");
        rw.writeAttribute("onfocus", (Object)this.getOnfocus(component, bean), "onfocus");
    }

    protected char getAccessKey(UIComponent component, FacesBean bean) {
        return GoLinkRenderer.toChar((Object)bean.getProperty(this._accessKeyKey));
    }

    protected String getDestination(UIComponent component, FacesBean bean) {
        return GoLinkRenderer.toResourceUri((FacesContext)FacesContext.getCurrentInstance(), (Object)bean.getProperty(this._destinationKey));
    }

    protected boolean getDisabled(UIComponent component, FacesBean bean) {
        Object o = bean.getProperty(this._disabledKey);
        if (o == null) {
            o = this._disabledKey.getDefault();
        }
        return Boolean.TRUE.equals(o);
    }

    protected boolean hasOnclick(UIComponent component, FacesBean bean) {
        return this.getOnclick(component, bean) != null;
    }

    protected String getOnblur(UIComponent component, FacesBean bean) {
        if (this._onblurKey == null) {
            return null;
        }
        return XhtmlUtils.getClientEventHandler(FacesContext.getCurrentInstance(), component, "blur", null, GoLinkRenderer.toString((Object)bean.getProperty(this._onblurKey)), null);
    }

    protected String getOnfocus(UIComponent component, FacesBean bean) {
        if (this._onfocusKey == null) {
            return null;
        }
        return XhtmlUtils.getClientEventHandler(FacesContext.getCurrentInstance(), component, "focus", null, GoLinkRenderer.toString((Object)bean.getProperty(this._onfocusKey)), null);
    }

    protected String getTargetFrame(UIComponent component, FacesBean bean) {
        return GoLinkRenderer.toString((Object)bean.getProperty(this._targetFrameKey));
    }

    protected String getText(UIComponent component, FacesBean bean) {
        return GoLinkRenderer.toString((Object)bean.getProperty(this._textKey));
    }

    @Override
    protected String getDefaultStyleClass(UIComponent component, FacesBean bean) {
        RenderingContext arc = RenderingContext.getCurrentInstance();
        if (((CoreRenderingContext)arc).isDefaultLinkStyleDisabled()) {
            return null;
        }
        if (this.getDisabled(component, bean)) {
            return "OraLinkDisabled";
        }
        return "OraLink";
    }
}

