/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.context;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELContext;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.RenderKit;
import org.apache.myfaces.trinidad.context.ExternalContextDecorator;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidadinternal.config.GlobalConfiguratorImpl;

public class FacesContextFactoryImpl
extends FacesContextFactory {
    private final FacesContextFactory _factory;

    public FacesContextFactoryImpl(FacesContextFactory factory) {
        this._factory = factory;
    }

    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) {
        return new CacheRenderKit(this._factory.getFacesContext(context, request, response, lifecycle));
    }

    public static class OverrideDispatch
    extends ExternalContextDecorator {
        private final ExternalContext _decorated;

        public OverrideDispatch(ExternalContext decorated) {
            this._decorated = decorated;
        }

        public void dispatch(String path) throws IOException {
            RequestContext afc = RequestContext.getCurrentInstance();
            if (afc != null) {
                path = afc.getPageResolver().getPhysicalURI(path);
            }
            super.dispatch(path);
        }

        protected ExternalContext getExternalContext() {
            return this._decorated;
        }
    }

    public static class CacheRenderKit
    extends FacesContext {
        private final FacesContext _base;
        private final ExternalContext _external;
        private Object _cachedRenderKitId;
        private RenderKit _kit;
        private static final String _CONFIG_IN_CONTEXT = FacesContextFactoryImpl.class.getName() + ".CONFIG_IN_CONTEXT";

        public CacheRenderKit(FacesContext base) {
            this._base = base;
            ExternalContext baseExternal = base.getExternalContext();
            GlobalConfiguratorImpl config = GlobalConfiguratorImpl.getInstance();
            if (!GlobalConfiguratorImpl.isRequestStarted(baseExternal)) {
                Map requestMap = baseExternal.getRequestMap();
                requestMap.put(_CONFIG_IN_CONTEXT, Boolean.TRUE);
            }
            this._external = new OverrideDispatch(config.getExternalContext(baseExternal));
            CacheRenderKit.setCurrentInstance((FacesContext)this);
        }

        public Application getApplication() {
            return this._base.getApplication();
        }

        public Iterator getClientIdsWithMessages() {
            return this._base.getClientIdsWithMessages();
        }

        public ExternalContext getExternalContext() {
            return this._external;
        }

        public FacesMessage.Severity getMaximumSeverity() {
            return this._base.getMaximumSeverity();
        }

        public Iterator getMessages() {
            return this._base.getMessages();
        }

        public Iterator getMessages(String clientId) {
            return this._base.getMessages(clientId);
        }

        public RenderKit getRenderKit() {
            if (this._kit == null) {
                this._kit = this._base.getRenderKit();
            } else {
                String renderKitId;
                UIViewRoot root = this.getViewRoot();
                if (root != null && (renderKitId = root.getRenderKitId()) != this._cachedRenderKitId) {
                    this._cachedRenderKitId = renderKitId;
                    this._kit = this._base.getRenderKit();
                }
            }
            return this._kit;
        }

        public boolean getRenderResponse() {
            return this._base.getRenderResponse();
        }

        public boolean getResponseComplete() {
            return this._base.getResponseComplete();
        }

        public ResponseStream getResponseStream() {
            return this._base.getResponseStream();
        }

        public void setResponseStream(ResponseStream responseStream) {
            this._base.setResponseStream(responseStream);
        }

        public ResponseWriter getResponseWriter() {
            return this._base.getResponseWriter();
        }

        public void setResponseWriter(ResponseWriter responseWriter) {
            this._base.setResponseWriter(responseWriter);
        }

        public UIViewRoot getViewRoot() {
            return this._base.getViewRoot();
        }

        public void setViewRoot(UIViewRoot viewRoot) {
            this._base.setViewRoot(viewRoot);
        }

        public void addMessage(String clientId, FacesMessage facesMessage) {
            this._base.addMessage(clientId, facesMessage);
        }

        public void renderResponse() {
            this._base.renderResponse();
        }

        public void responseComplete() {
            this._base.responseComplete();
        }

        public void release() {
            ExternalContext ec = this.getExternalContext();
            if (Boolean.TRUE.equals(ec.getRequestMap().get(_CONFIG_IN_CONTEXT))) {
                GlobalConfiguratorImpl.getInstance().endRequest(ec);
            }
            this._base.release();
        }

        public ELContext getELContext() {
            return this._base.getELContext();
        }
    }
}

