/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.trinidad.bean.FacesBean;
import org.apache.myfaces.trinidad.bean.PropertyKey;
import org.apache.myfaces.trinidad.component.html.HtmlMeta;
import org.apache.myfaces.trinidad.context.RenderingContext;
import org.apache.myfaces.trinidadinternal.renderkit.core.xhtml.XhtmlRenderer;

public class MetaRenderer
extends XhtmlRenderer {
    private PropertyKey _nameKey;
    private PropertyKey _typeKey;
    private PropertyKey _contentKey;

    public MetaRenderer() {
        super(HtmlMeta.TYPE);
    }

    protected void findTypeConstants(FacesBean.Type type) {
        super.findTypeConstants(type);
        this._nameKey = type.findKey("name");
        this._typeKey = type.findKey("type");
        this._contentKey = type.findKey("content");
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void encodeAll(FacesContext context, RenderingContext rc, UIComponent component, FacesBean bean) throws IOException {
        String content;
        ResponseWriter rw = context.getResponseWriter();
        rw.startElement("meta", component);
        String name = this.getName(bean);
        if (name != null) {
            String type = this.getType(bean);
            if (type != null && "httpEquiv".equals(type)) {
                rw.writeAttribute("http-equiv", (Object)name, null);
            } else {
                rw.writeAttribute("name", (Object)name, null);
            }
        }
        if ((content = this.getContent(bean)) != null) {
            rw.writeAttribute("content", (Object)content, null);
        }
        this.encodeAllChildren(context, component);
        rw.endElement("meta");
    }

    protected String getName(FacesBean bean) {
        return MetaRenderer.toString((Object)bean.getProperty(this._nameKey));
    }

    protected String getType(FacesBean bean) {
        return MetaRenderer.toString((Object)bean.getProperty(this._typeKey));
    }

    protected String getContent(FacesBean bean) {
        return MetaRenderer.toString((Object)bean.getProperty(this._contentKey));
    }
}

