/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.ext;

import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.component.html.ext.HtmlDataTable;
import org.apache.myfaces.component.html.ext.HtmlTableRow;
import org.apache.myfaces.renderkit.html.ext.HtmlTableRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlTableRendererBase;
import org.apache.myfaces.shared_tomahawk.util.ArrayUtils;
import org.apache.myfaces.shared_tomahawk.util.StringUtils;

public class HtmlTableRowRenderer
extends HtmlTableRenderer {
    private static final Logger log = Logger.getLogger(HtmlTableRowRenderer.class.getName());
    private static final Integer[] ZERO_INT_ARRAY = new Integer[]{0};

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, HtmlTableRow.class);
        ResponseWriter writer = facesContext.getResponseWriter();
        UIData uiData = (UIData)component.getParent();
        if (uiData instanceof HtmlDataTable) {
            int last;
            HtmlDataTable htmlDataTable = (HtmlDataTable)uiData;
            int rowCount = uiData.getRowCount();
            HtmlTableRendererBase.Styles styles = HtmlTableRowRenderer.getStyles(uiData);
            int first = uiData.getFirst();
            int rows = uiData.getRows();
            if (rows <= 0) {
                last = rowCount;
            } else {
                last = first + rows;
                if (last > rowCount) {
                    last = rowCount;
                }
            }
            int newspaperColumns = this.getNewspaperColumns((UIComponent)uiData);
            int newspaperRows = (last - first) % newspaperColumns == 0 ? (last - first) / newspaperColumns : (last - first) / newspaperColumns + 1;
            boolean newspaperHorizontalOrientation = this.isNewspaperHorizontalOrientation((UIComponent)uiData);
            Object[] bodyrows = null;
            String bodyrowsAttr = (String)uiData.getAttributes().get("bodyrows");
            if (bodyrowsAttr != null && !"".equals(bodyrowsAttr)) {
                String[] bodyrowsString = StringUtils.trim(StringUtils.splitShortString(bodyrowsAttr, ','));
                bodyrows = new Integer[bodyrowsString.length];
                for (int i = 0; i < bodyrowsString.length; ++i) {
                    bodyrows[i] = new Integer(bodyrowsString[i]);
                }
            } else {
                bodyrows = ZERO_INT_ARRAY;
            }
            int savedRow = uiData.getRowIndex();
            int nr = newspaperHorizontalOrientation ? (savedRow - first) / newspaperColumns : savedRow - first;
            boolean rowStartRendered = false;
            for (int nc = 0; nc < newspaperColumns; ++nc) {
                int currentRow = newspaperHorizontalOrientation ? nr * newspaperColumns + nc + first : nc * newspaperRows + nr + first;
                if (currentRow >= last) continue;
                uiData.setRowIndex(currentRow);
                if (!uiData.isRowAvailable()) {
                    log.severe("Row is not available. Rowindex = " + currentRow);
                    break;
                }
                if (nc == 0) {
                    if (ArrayUtils.contains(bodyrows, currentRow)) {
                        // empty if block
                    }
                    HtmlRendererUtils.writePrettyLineSeparator(facesContext);
                    this.renderRowStart(facesContext, writer, uiData, styles, nr);
                    rowStartRendered = true;
                }
                List<UIComponent> children = this.getChildren((UIComponent)uiData);
                int size = this.getChildCount((UIComponent)uiData);
                for (int j = 0; j < size; ++j) {
                    UIComponent child = children.get(j);
                    if (!child.isRendered()) continue;
                    boolean columnRendering = child instanceof UIColumn;
                    if (columnRendering) {
                        this.beforeColumn(facesContext, uiData, j);
                    }
                    this.encodeColumnChild(facesContext, writer, uiData, child, styles, nc * uiData.getChildCount() + j);
                    if (!columnRendering) continue;
                    this.afterColumn(facesContext, uiData, j);
                }
                if (!this.hasNewspaperTableSpacer((UIComponent)uiData) || nc >= newspaperColumns - 1) continue;
                this.renderSpacerCell(facesContext, writer, (UIComponent)uiData);
            }
            if (rowStartRendered) {
                this.renderRowEnd(facesContext, writer, uiData);
            }
            if (uiData.getRowIndex() != savedRow) {
                uiData.setRowIndex(savedRow);
            }
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void decode(FacesContext context, UIComponent component) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
    }

    public String convertClientId(FacesContext context, String clientId) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (clientId == null) {
            throw new NullPointerException("clientId");
        }
        return clientId;
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (component == null) {
            throw new NullPointerException("component");
        }
        return submittedValue;
    }
}

