/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.stylesheet;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.custom.stylesheet.Stylesheet;
import org.apache.myfaces.custom.stylesheet.TextResourceFilter;
import org.apache.myfaces.custom.stylesheet.TextResourceFilterProvider;
import org.apache.myfaces.renderkit.html.util.AddResourceFactory;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.util.WebConfigParamUtils;
import org.apache.myfaces.tomahawk.util.ExternalContextUtils;

public class StylesheetRenderer
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog(StylesheetRenderer.class);

    private static boolean getBooleanInitParameterValue(String initParameter, boolean defaultVal) {
        if (initParameter == null || initParameter.trim().length() == 0) {
            return defaultVal;
        }
        return initParameter.equalsIgnoreCase("on") || initParameter.equals("1") || initParameter.equalsIgnoreCase("true");
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException, FacesException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        Stylesheet stylesheet = (Stylesheet)component;
        ResponseWriter writer = context.getResponseWriter();
        String path = stylesheet.getPath();
        if (stylesheet.isInline()) {
            String text;
            if (!path.startsWith("/")) {
                throw new FacesException("Inline stylesheets require absolute resource path");
            }
            writer.startElement("style", component);
            writer.writeAttribute("type", (Object)"text/css", null);
            if (stylesheet.getMedia() != null) {
                writer.writeAttribute("media", (Object)stylesheet.getMedia(), null);
            }
            if (stylesheet.isFiltered()) {
                TextResourceFilter.ResourceInfo info = TextResourceFilter.getInstance(context).getOrCreateFilteredResource(context, path);
                text = info.getText();
            } else {
                text = RendererUtils.loadResourceFile(context, path);
            }
            if (text != null) {
                writer.writeText((Object)text, null);
            }
            writer.endElement("style");
        } else {
            String stylesheetPath;
            writer.startElement("link", component);
            writer.writeAttribute("rel", (Object)"stylesheet", null);
            writer.writeAttribute("type", (Object)"text/css", null);
            if (stylesheet.getMedia() != null) {
                writer.writeAttribute("media", (Object)stylesheet.getMedia(), null);
            }
            if (stylesheet.isFiltered()) {
                if (!path.startsWith("/")) {
                    throw new FacesException("Filtered stylesheets require absolute resource path");
                }
                TextResourceFilter.getInstance(context).getOrCreateFilteredResource(context, path);
                boolean isDisabledTomahawkFacesContextWrapper = StylesheetRenderer.getBooleanInitParameterValue(WebConfigParamUtils.getStringInitParameter(context.getExternalContext(), "org.apache.myfaces.DISABLE_TOMAHAWK_FACES_CONTEXT_WRAPPER"), true);
                if (!context.isProjectStage(ProjectStage.Production)) {
                    boolean isPortlet = ExternalContextUtils.getRequestType(context.getExternalContext()).isPortlet();
                    boolean extensionsFilterInitialized = context.getExternalContext().getApplicationMap().containsKey("org.apache.myfaces.tomahawk.EXTENSIONS_FILTER_INITIALIZED");
                    if ((isPortlet && isDisabledTomahawkFacesContextWrapper || isDisabledTomahawkFacesContextWrapper && !extensionsFilterInitialized) && log.isWarnEnabled()) {
                        log.warn((Object)"t:stylesheet with filtered=\"true\" requires ExtensionsFilter or TomahawkFacesContextFactory to handle the css resource, and any of them has been detected. Please read the instructions on http://myfaces.apache.org/tomahawk/extensionsFilter.html for more information about how to setup your environment correctly. ServeResourcePhaseListener could handle the resource request too automatically if you use prefix mapping and org.apache.myfaces.RESOURCE_VIRTUAL_PATH match (Default is /faces/myFacesExtensionResource), so please ignore this warning if you are using it.");
                    }
                }
                String nastyPathHack = path.substring(1);
                stylesheetPath = AddResourceFactory.getInstance(context).getResourceUri(context, TextResourceFilterProvider.class, nastyPathHack, true);
            } else {
                stylesheetPath = context.getApplication().getViewHandler().getResourceURL(context, path);
            }
            writer.writeURIAttribute("href", (Object)stylesheetPath, "path");
            writer.endElement("link");
        }
    }
}

