/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.taglib;

import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.UITreeIndent;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.taglib.TobagoELTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TreeIndentTag
extends TobagoELTag {
    private static final Logger LOG = LoggerFactory.getLogger(TreeIndentTag.class);
    private ValueExpression markup;
    private ValueExpression showJunctions;
    private ValueExpression tip;

    public String getComponentType() {
        return "org.apache.myfaces.tobago.TreeIndent";
    }

    public String getRendererType() {
        return "TreeIndent";
    }

    protected void setProperties(UIComponent uiComponent) {
        super.setProperties(uiComponent);
        UITreeIndent component = (UITreeIndent)uiComponent;
        FacesContext context = FacesContext.getCurrentInstance();
        Application application = context.getApplication();
        if (this.markup != null) {
            if (!this.markup.isLiteralText()) {
                component.setValueExpression("markup", this.markup);
            } else {
                component.setMarkup(Markup.valueOf(this.markup.getExpressionString()));
            }
        }
        if (this.showJunctions != null) {
            if (!this.showJunctions.isLiteralText()) {
                component.setValueExpression("showJunctions", this.showJunctions);
            } else {
                component.setShowJunctions(Boolean.parseBoolean(this.showJunctions.getExpressionString()));
            }
        }
        if (this.tip != null) {
            component.setValueExpression("tip", this.tip);
        }
    }

    public ValueExpression getMarkup() {
        return this.markup;
    }

    public void setMarkup(ValueExpression markup) {
        this.markup = markup;
    }

    public ValueExpression getShowJunctions() {
        return this.showJunctions;
    }

    public void setShowJunctions(ValueExpression showJunctions) {
        this.showJunctions = showJunctions;
    }

    public ValueExpression getTip() {
        return this.tip;
    }

    public void setTip(ValueExpression tip) {
        this.tip = tip;
    }

    public void release() {
        super.release();
        this.markup = null;
        this.showJunctions = null;
        this.tip = null;
    }
}

