/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.el;

import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import org.apache.myfaces.test.el.ExpressionTokenizer;

public class MockValueExpression
extends ValueExpression {
    private static final long serialVersionUID = -8649071428507512623L;
    private String[] elements = null;
    private Class expectedType = null;
    private String expression = null;

    public MockValueExpression(String expression, Class expectedType) {
        if (expression == null) {
            throw new NullPointerException("Expression string cannot be null");
        }
        this.expression = expression;
        this.expectedType = expectedType;
        this.parse();
    }

    public boolean equals(Object obj) {
        if (obj != null & obj instanceof ValueExpression) {
            return this.expression.equals(((ValueExpression)obj).getExpressionString());
        }
        return false;
    }

    public String getExpressionString() {
        return this.expression;
    }

    public int hashCode() {
        return this.expression.hashCode();
    }

    public boolean isLiteralText() {
        return this.expression.indexOf("${") < 0 && this.expression.indexOf("#{") < 0;
    }

    public Class getExpectedType() {
        return this.expectedType;
    }

    public Class getType(ELContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object value = this.getValue(context);
        if (value == null) {
            if (this.isLiteralText()) {
                return String.class;
            }
            ELResolver resolver = context.getELResolver();
            Object base = null;
            for (int i = 0; i < this.elements.length - 1; ++i) {
                base = resolver.getValue(context, base, (Object)this.elements[i]);
            }
            return resolver.getType(context, base, (Object)this.elements[this.elements.length - 1]);
        }
        return value.getClass();
    }

    public Object getValue(ELContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.isLiteralText()) {
            return this.expression;
        }
        FacesContext fcontext = (FacesContext)context.getContext(FacesContext.class);
        ELResolver resolver = context.getELResolver();
        Object base = null;
        for (int i = 0; i < this.elements.length; ++i) {
            base = resolver.getValue(context, base, (Object)this.elements[i]);
        }
        return fcontext.getApplication().getExpressionFactory().coerceToType(base, this.getExpectedType());
    }

    public boolean isReadOnly(ELContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.isLiteralText()) {
            return true;
        }
        ELResolver resolver = context.getELResolver();
        Object base = null;
        for (int i = 0; i < this.elements.length - 1; ++i) {
            base = resolver.getValue(context, base, (Object)this.elements[i]);
        }
        return resolver.isReadOnly(context, base, (Object)this.elements[this.elements.length - 1]);
    }

    public void setValue(ELContext context, Object value) {
        if (context == null) {
            throw new NullPointerException();
        }
        ELResolver resolver = context.getELResolver();
        Object base = null;
        for (int i = 0; i < this.elements.length - 1; ++i) {
            base = resolver.getValue(context, base, (Object)this.elements[i]);
        }
        resolver.setValue(context, base, (Object)this.elements[this.elements.length - 1], value);
    }

    private void parse() {
        if (this.isLiteralText()) {
            this.elements = new String[0];
            return;
        }
        if (this.expression.startsWith("${") || this.expression.startsWith("#{")) {
            if (!this.expression.endsWith("}")) {
                throw new IllegalArgumentException(this.expression);
            }
        } else {
            throw new IllegalArgumentException(this.expression);
        }
        this.elements = ExpressionTokenizer.tokenize(this.expression.substring(2, this.expression.length() - 1));
    }
}

