/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.frameworkAdapter.basic;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.orchestra.conversation.ConversationMessager;
import org.apache.myfaces.orchestra.conversation.basic.LogConversationMessager;
import org.apache.myfaces.orchestra.frameworkAdapter.FrameworkAdapter;
import org.apache.myfaces.orchestra.lib._ClassUtils;

public class BasicFrameworkAdapter
extends FrameworkAdapter {
    private static final String ISE_MESSAGE = "No request/response data available";
    private static final ThreadLocal httpServletRequestThreadLocal = new ThreadLocal();
    private static final ThreadLocal httpServletResponseThreadLocal = new ThreadLocal();
    private final Log log = LogFactory.getLog(BasicFrameworkAdapter.class);
    private final ServletContext servletContext;
    private final String conversationMessagerClass;

    public BasicFrameworkAdapter(ServletContext context, String conversationMessagerClass) {
        this.servletContext = context;
        this.conversationMessagerClass = conversationMessagerClass;
    }

    protected ConversationMessager createConversationMessager() {
        if (this.conversationMessagerClass == null) {
            return this.createDefaultConversationMessager();
        }
        Object instance = this.getBean(this.conversationMessagerClass);
        if (instance instanceof ConversationMessager) {
            return (ConversationMessager)instance;
        }
        return (ConversationMessager)_ClassUtils.newInstance(this.conversationMessagerClass);
    }

    protected ConversationMessager createDefaultConversationMessager() {
        return new LogConversationMessager();
    }

    private HttpServletRequest getRequest() {
        return (HttpServletRequest)httpServletRequestThreadLocal.get();
    }

    private HttpServletResponse getResponse() {
        return (HttpServletResponse)httpServletResponseThreadLocal.get();
    }

    public void beginRequest(ServletRequest req, ServletResponse rsp) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Beginning request");
        }
        if (req instanceof HttpServletRequest) {
            httpServletRequestThreadLocal.set(req);
        }
        if (rsp instanceof HttpServletResponse) {
            httpServletResponseThreadLocal.set(rsp);
        }
        FrameworkAdapter.setCurrentInstance(this);
    }

    public void endRequest() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Ending request");
        }
        FrameworkAdapter.setCurrentInstance(null);
        httpServletRequestThreadLocal.set(null);
        httpServletResponseThreadLocal.set(null);
    }

    public String getInitParameter(String key) {
        return this.servletContext.getInitParameter(key);
    }

    public Object getRequestParameterAttribute(String key) {
        HttpServletRequest request = this.getRequest();
        if (request != null) {
            return request.getParameter(key);
        }
        throw new IllegalStateException(ISE_MESSAGE);
    }

    public boolean containsRequestParameterAttribute(String key) {
        HttpServletRequest request = this.getRequest();
        if (request != null) {
            return request.getParameter(key) != null;
        }
        throw new IllegalStateException(ISE_MESSAGE);
    }

    public Object getRequestAttribute(String key) {
        HttpServletRequest request = this.getRequest();
        if (request != null) {
            return request.getAttribute(key);
        }
        throw new IllegalStateException(ISE_MESSAGE);
    }

    public void setRequestAttribute(String key, Object value) {
        HttpServletRequest request = this.getRequest();
        if (request != null) {
            request.setAttribute(key, value);
            return;
        }
        throw new IllegalStateException(ISE_MESSAGE);
    }

    public boolean containsRequestAttribute(String key) {
        HttpServletRequest request = this.getRequest();
        if (request != null) {
            return request.getAttribute(key) != null;
        }
        throw new IllegalStateException(ISE_MESSAGE);
    }

    public Object getSessionAttribute(String key) {
        HttpServletRequest request = this.getRequest();
        if (request != null && request.getSession(true) != null) {
            return request.getSession(true).getAttribute(key);
        }
        throw new IllegalStateException(ISE_MESSAGE);
    }

    public void setSessionAttribute(String key, Object value) {
        HttpServletRequest request = this.getRequest();
        if (request != null && request.getSession(true) != null) {
            request.getSession(true).setAttribute(key, value);
            return;
        }
    }

    public boolean containsSessionAttribute(String key) {
        HttpServletRequest request = this.getRequest();
        if (request != null && request.getSession(true) != null) {
            return request.getSession(true).getAttribute(key) != null;
        }
        throw new IllegalStateException(ISE_MESSAGE);
    }

    protected String getRequestContextPath() {
        HttpServletRequest request = this.getRequest();
        if (request != null) {
            return request.getContextPath();
        }
        throw new IllegalStateException(ISE_MESSAGE);
    }

    public void redirect(String url) throws IOException {
        StringBuffer redir = new StringBuffer();
        if (url.startsWith("/")) {
            redir.append(this.getRequestContextPath());
        }
        redir.append(url);
        HttpServletResponse rsp = this.getResponse();
        String dstUrl = rsp.encodeRedirectURL(redir.toString());
        rsp.sendRedirect(dstUrl);
    }

    public Object getBean(String name) {
        Object obj = this.getRequestAttribute(name);
        if (obj != null) {
            return obj;
        }
        obj = this.getSessionAttribute(name);
        if (obj != null) {
            return obj;
        }
        return null;
    }

    public void invokeNavigation(String navigationName) throws IOException {
        this.redirect(navigationName);
    }
}

