/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.myfaces.orchestra.lib.jsf;

import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextWrapper;

import org.apache.myfaces.orchestra.requestParameterProvider.RequestParameterProviderManager;

/**
 * Class used by _PortletFacesContextWrapper to allow orchestra work in portlets
 * 
 * This class wraps encodeActionURL and encodeResourceURL to include
 * conversationContext param like RequestParameterResponseWrapper does. In portlets
 * we can't do the same than is servlets, because the params added here must be
 * encoded by the portlet container and in portlets we don't have servlet redirect
 * cases.
 * 
 * @author Leonardo Uribe(latest modification by $Author: lu4242 $)
 * @version $Revision: 798382 $ $Date: 2009-07-27 22:23:02 -0500 (lun, 27 jul 2009) $
 */
public class PortletExternalContextWrapper extends ExternalContextWrapper
{
    private ExternalContext _delegate;

    public PortletExternalContextWrapper(ExternalContext context)
    {
        super();
        this._delegate = context;
    }
    
    @Override
    public ExternalContext getWrapped()
    {
        return _delegate;
    }

    public String encodeActionURL(String url)
    {
        if (url != null)
        {
            url = RequestParameterProviderManager.getInstance().encodeAndAttachParameters(url);
        }
        return getWrapped().encodeActionURL(url);
    }

    public String encodeResourceURL(String url)
    {
        if (url != null)
        {
            url = RequestParameterProviderManager.getInstance().encodeAndAttachParameters(url);
        }
        return getWrapped().encodeResourceURL(url);
    }
}
