/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.orchestra.viewController.spring;

import org.apache.myfaces.orchestra.conversation.Conversation;
import org.apache.myfaces.orchestra.conversation.ConversationContext;
import org.apache.myfaces.orchestra.conversation.spring.AbstractSpringOrchestraScope;
import org.apache.myfaces.orchestra.frameworkAdapter.FrameworkAdapter;
import org.apache.myfaces.orchestra.lib.OrchestraException;
import org.apache.myfaces.orchestra.viewController.DefaultViewControllerManager;
import org.apache.myfaces.orchestra.viewController.ViewControllerManager;
import org.springframework.aop.scope.ScopedProxyFactoryBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringViewControllerScope
extends AbstractSpringOrchestraScope {
    private static final ViewControllerManager DEFAULT_VCM = new DefaultViewControllerManager();

    public Conversation createConversation(ConversationContext context, String conversationName) {
        throw new IllegalStateException("The viewController scope is not supposed to start a conversation on its own. Conversation to start: " + conversationName);
    }

    protected void assertSameScope(String beanName, Conversation conversation) {
    }

    public String getConversationNameForBean(String beanName) {
        String scopeName;
        String viewId;
        ViewControllerManager viewControllerManager = this.getViewControllerManager();
        String viewControllerName = viewControllerManager.getViewControllerName(viewId = FrameworkAdapter.getCurrentInstance().getCurrentViewId());
        if (viewControllerName == null) {
            throw new OrchestraException("Error while processing bean " + beanName + ": no view controller name found for view " + viewId);
        }
        ConfigurableApplicationContext appContext = this.getApplicationContext();
        ConfigurableListableBeanFactory beanFactory = appContext.getBeanFactory();
        BeanDefinition beanDefinition = beanFactory.getBeanDefinition(viewControllerName);
        if (beanDefinition.getBeanClassName().equals(ScopedProxyFactoryBean.class.getName())) {
            beanDefinition = beanFactory.getBeanDefinition("scopedTarget." + viewControllerName);
        }
        if ((scopeName = beanDefinition.getScope()) == null) {
            throw new OrchestraException("Error while processing bean " + beanName + ": view controller " + viewControllerName + " has no scope.");
        }
        Scope registeredScope = beanFactory.getRegisteredScope(scopeName);
        if (registeredScope == null) {
            throw new OrchestraException("Error while processing bean " + beanName + ": view controller " + viewControllerName + " has unknown scope " + scopeName);
        }
        if (registeredScope instanceof AbstractSpringOrchestraScope) {
            return ((AbstractSpringOrchestraScope)registeredScope).getConversationNameForBean(viewControllerName);
        }
        throw new OrchestraException("Error while processing bean " + beanName + ": the scope " + scopeName + " should be of type AbstractSpringOrchestraScope" + ", but is type " + registeredScope.getClass().getName());
    }

    private ViewControllerManager getViewControllerManager() {
        try {
            return (ViewControllerManager)this.getApplicationContext().getBean(ViewControllerManager.VIEW_CONTROLLER_MANAGER_NAME, ViewControllerManager.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            return DEFAULT_VCM;
        }
    }
}

