/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.beanval.storage;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.apache.myfaces.extensions.validator.beanval.storage.ModelValidationEntry;
import org.apache.myfaces.extensions.validator.beanval.storage.ModelValidationStorage;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.GroupUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.INTERNAL})
public class DefaultModelValidationStorage
implements ModelValidationStorage {
    private Map<String, List<ModelValidationEntry>> modelValidationEntries = new HashMap<String, List<ModelValidationEntry>>();
    private List<String> componentsOfRequest = new ArrayList<String>();

    @Override
    public void addModelValidationEntry(ModelValidationEntry modelValidationEntry) {
        String clientId = this.getCurrentClientId(modelValidationEntry);
        List<ModelValidationEntry> modelValidationEntryList = this.resolveModelValidationEntryList(modelValidationEntry, clientId);
        this.addModelValidationEntry(modelValidationEntryList, modelValidationEntry);
    }

    private String getCurrentClientId(ModelValidationEntry modelValidationEntry) {
        String clientId = null;
        if (modelValidationEntry.getComponent() != null && !this.componentsOfRequest.contains(clientId = modelValidationEntry.getComponent().getClientId(FacesContext.getCurrentInstance()))) {
            this.componentsOfRequest.add(clientId);
        }
        return clientId;
    }

    private List<ModelValidationEntry> resolveModelValidationEntryList(ModelValidationEntry modelValidationEntry, String clientId) {
        List<ModelValidationEntry> modelValidationEntryList = this.modelValidationEntries.get(GroupUtils.getGroupKey((String)modelValidationEntry.getViewId(), (String)clientId));
        if (modelValidationEntryList == null) {
            modelValidationEntryList = new ArrayList<ModelValidationEntry>();
            this.modelValidationEntries.put(GroupUtils.getGroupKey((String)modelValidationEntry.getViewId(), (String)clientId), modelValidationEntryList);
        }
        return modelValidationEntryList;
    }

    private void addModelValidationEntry(List<ModelValidationEntry> modelValidationEntryList, ModelValidationEntry modelValidationEntry) {
        if (!modelValidationEntryList.contains(modelValidationEntry)) {
            modelValidationEntryList.add(modelValidationEntry);
        }
    }

    @Override
    public List<ModelValidationEntry> getModelValidationEntriesToValidate() {
        String viewId = FacesContext.getCurrentInstance().getViewRoot().getViewId();
        ArrayList<ModelValidationEntry> result = new ArrayList<ModelValidationEntry>();
        this.addEntriesForComponents(viewId, result);
        this.addEntriesForPage(viewId, result);
        return result;
    }

    private void addEntriesForComponents(String viewId, List<ModelValidationEntry> result) {
        for (String currentClientId : this.componentsOfRequest) {
            result.addAll(this.getModelValidationEntries(viewId, currentClientId));
        }
    }

    private void addEntriesForPage(String viewId, List<ModelValidationEntry> result) {
        result.addAll(this.getModelValidationEntries(viewId));
    }

    private List<ModelValidationEntry> buildModelValidationEntryList(String key, Map<String, List<ModelValidationEntry>> groupStorage) {
        if (key != null && key.endsWith("*")) {
            ArrayList<ModelValidationEntry> list = new ArrayList<ModelValidationEntry>();
            for (Map.Entry<String, List<ModelValidationEntry>> entry : groupStorage.entrySet()) {
                if (!entry.getKey().substring(0, entry.getKey().indexOf("@")).equals(key.substring(0, key.indexOf("@")))) continue;
                list.addAll((Collection<ModelValidationEntry>)entry.getValue());
            }
            return list;
        }
        ArrayList list = groupStorage.get(key);
        return list != null ? list : new ArrayList();
    }

    private List<ModelValidationEntry> getModelValidationEntries(String viewId) {
        return this.getModelValidationEntries(viewId, null);
    }

    private List<ModelValidationEntry> getModelValidationEntries(String viewId, String clientId) {
        String key;
        if (this.modelValidationEntries.size() < 1) {
            return new ArrayList<ModelValidationEntry>();
        }
        List<ModelValidationEntry> resultListForPage = null;
        if (!"*".equals(clientId)) {
            key = GroupUtils.getGroupKey((String)viewId, null);
            resultListForPage = this.buildModelValidationEntryList(key, this.modelValidationEntries);
        }
        key = GroupUtils.getGroupKey((String)viewId, (String)clientId);
        List<ModelValidationEntry> resultListForComponent = this.buildModelValidationEntryList(key, this.modelValidationEntries);
        if (resultListForPage == null || resultListForPage.isEmpty()) {
            return resultListForComponent;
        }
        if (resultListForComponent.isEmpty()) {
            return resultListForPage;
        }
        return this.mergeResults(resultListForPage, resultListForComponent);
    }

    private List<ModelValidationEntry> mergeResults(List<ModelValidationEntry> resultListForPage, List<ModelValidationEntry> resultListForComponent) {
        ArrayList<ModelValidationEntry> mergedResult = new ArrayList<ModelValidationEntry>();
        mergedResult.addAll(resultListForPage);
        mergedResult.addAll(resultListForComponent);
        return mergedResult;
    }
}

