/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.api.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Map;
import javax.enterprise.context.SessionScoped;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.extensions.cdi.core.api.projectstage.ProjectStage;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;

@SessionScoped
public class ClientConfig
implements Serializable {
    private static final long serialVersionUID = 581351549574404793L;
    public static final String COOKIE_NAME_NOSCRIPT_ENABLED = "mfNoScriptEnabled";
    private volatile Boolean javaScriptEnabled = null;
    protected String windowHandlerHtml;
    private volatile String userAgent = null;
    @Inject
    private ProjectStage projectStage;
    private static final String DEFAULT_WINDOW_HANDLER_HTML_FILE = "static/windowhandler.html";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJavaScriptEnabled() {
        if (this.javaScriptEnabled == null) {
            ClientConfig clientConfig = this;
            synchronized (clientConfig) {
                if (this.javaScriptEnabled == null) {
                    Cookie cookie;
                    this.javaScriptEnabled = Boolean.TRUE;
                    FacesContext facesContext = FacesContext.getCurrentInstance();
                    if (facesContext != null && (cookie = (Cookie)facesContext.getExternalContext().getRequestCookieMap().get(COOKIE_NAME_NOSCRIPT_ENABLED)) != null) {
                        this.javaScriptEnabled = Boolean.parseBoolean(cookie.getValue());
                    }
                }
            }
        }
        return this.javaScriptEnabled;
    }

    public void setJavaScriptEnabled(boolean javaScriptEnabled) {
        Object r;
        this.javaScriptEnabled = javaScriptEnabled;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (r = facesContext.getExternalContext().getResponse()) instanceof HttpServletResponse) {
            Cookie cookie = new Cookie(COOKIE_NAME_NOSCRIPT_ENABLED, "" + javaScriptEnabled);
            cookie.setPath("/");
            HttpServletResponse response = (HttpServletResponse)r;
            response.addCookie(cookie);
        }
    }

    public String getWindowHandlerResourceLocation() {
        return DEFAULT_WINDOW_HANDLER_HTML_FILE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWindowHandlerHtml() throws IOException {
        if (this.projectStage != ProjectStage.Development && this.windowHandlerHtml != null) {
            return this.windowHandlerHtml;
        }
        InputStream is = ClassUtils.getClassLoader(null).getResourceAsStream(this.getWindowHandlerResourceLocation());
        StringBuffer sb = new StringBuffer();
        try {
            int bytesRead;
            byte[] buf = new byte[16384];
            while ((bytesRead = is.read(buf)) != -1) {
                String sbuf = new String(buf, 0, bytesRead);
                sb.append(sbuf);
            }
        }
        finally {
            is.close();
        }
        this.windowHandlerHtml = sb.toString();
        return this.windowHandlerHtml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserAgent(FacesContext facesContext) {
        if (this.userAgent == null) {
            ClientConfig clientConfig = this;
            synchronized (clientConfig) {
                Map requestHeaders;
                if (this.userAgent == null && (requestHeaders = facesContext.getExternalContext().getRequestHeaderValuesMap()) != null && requestHeaders.containsKey("User-Agent")) {
                    String[] userAgents = (String[])requestHeaders.get("User-Agent");
                    this.userAgent = userAgents.length > 0 ? userAgents[0] : null;
                }
            }
        }
        return this.userAgent;
    }

    public boolean isClientSideWindowHandlerRequest(FacesContext facesContext) {
        if (!this.isJavaScriptEnabled()) {
            return false;
        }
        String userAgent = this.getUserAgent(facesContext);
        return userAgent == null || userAgent.indexOf("bot") < 0 && userAgent.indexOf("Bot") < 0 && userAgent.indexOf("Slurp") < 0 && userAgent.indexOf("Crawler") < 0;
    }
}

