/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.compiler;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.FunctionMapper;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.FaceletException;
import jakarta.faces.view.facelets.FaceletHandler;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.myfaces.el.FacesELContext;
import org.apache.myfaces.view.facelets.el.CompositeFunctionMapper;
import org.apache.myfaces.view.facelets.tag.TagLibrary;
import org.apache.myfaces.view.facelets.tag.composite.CompositeComponentResourceTagHandler;

final class NamespaceHandler
extends FunctionMapper
implements FaceletHandler {
    private final TagLibrary library;
    private final Map<String, String> ns;
    private FaceletHandler next;

    public NamespaceHandler(FaceletHandler next, TagLibrary library, Map<String, String> ns) {
        this.library = library;
        this.ns = ns;
        this.next = next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        FunctionMapper orig = ctx.getFunctionMapper();
        ELContext elContext = ctx.getFacesContext().getELContext();
        if (elContext instanceof FacesELContext) {
            ((FacesELContext)elContext).setFunctionMapper(this);
        }
        ctx.setFunctionMapper(new CompositeFunctionMapper(this, orig));
        try {
            this.next.apply(ctx, parent);
        }
        finally {
            ctx.setFunctionMapper(orig);
        }
    }

    public Method resolveFunction(String prefix, String localName) {
        String uri = this.ns.get(prefix);
        if (uri != null) {
            return this.library.createFunction(uri, localName);
        }
        return null;
    }

    public boolean isNextHandlerComponent() {
        return this.next instanceof ComponentHandler;
    }

    public boolean isNextHandlerCompositeComponent() {
        return this.next instanceof CompositeComponentResourceTagHandler;
    }
}

