/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.component.behavior;

import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.inject.Qualifier;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER})
@Inherited
@Qualifier
public @interface FacesBehavior {
    public String value();

    public boolean managed() default false;

    public static final class Literal
    extends AnnotationLiteral<FacesBehavior>
    implements FacesBehavior {
        private static final long serialVersionUID = 1L;
        public static final Literal INSTANCE = Literal.of("", false);
        private final String value;
        private final boolean managed;

        public static Literal of(String value, boolean managed) {
            return new Literal(value, managed);
        }

        private Literal(String value, boolean managed) {
            this.value = value;
            this.managed = managed;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public boolean managed() {
            return this.managed;
        }

        @Override
        public int hashCode() {
            int hash = 3;
            hash = 13 * hash + Objects.hashCode(this.value);
            hash = 13 * hash + (this.managed ? 1 : 0);
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Literal other = (Literal)obj;
            if (this.managed != other.managed) {
                return false;
            }
            return Objects.equals(this.value, other.value);
        }
    }
}

