/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.taglib.core;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.Converter;
import jakarta.faces.webapp.ConverterELTag;
import jakarta.servlet.jsp.JspException;
import org.apache.myfaces.taglib.core.DelegateConverter;

public class ConverterImplTag
extends ConverterELTag {
    private static final long serialVersionUID = -4506829108081L;
    private ValueExpression _converterId;
    private ValueExpression _binding;
    private String _converterIdString = null;

    public void setConverterId(ValueExpression converterId) {
        this._converterId = converterId;
    }

    public void setBinding(ValueExpression binding) {
        this._binding = binding;
    }

    public void setConverterIdString(String converterIdString) {
        this._converterIdString = converterIdString;
    }

    public void release() {
        super.release();
        this._converterId = null;
        this._binding = null;
        this._converterIdString = null;
    }

    @Override
    protected Converter createConverter() throws JspException {
        if (this._converterId != null && this._converterId.isLiteralText()) {
            return this.createClassicConverter();
        }
        if (this._converterIdString != null) {
            return this.createClassicConverter();
        }
        return new DelegateConverter(this._converterId, this._binding, this._converterIdString);
    }

    protected Converter createClassicConverter() throws JspException {
        Converter converter = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext elContext = facesContext.getELContext();
        if (this._binding != null) {
            try {
                converter = (Converter)this._binding.getValue(elContext);
                if (converter != null) {
                    return converter;
                }
            }
            catch (Exception e) {
                throw new JspException("Exception creating converter using binding", (Throwable)e);
            }
        }
        if (this._converterId != null || this._converterIdString != null) {
            try {
                if (null != this._converterIdString) {
                    converter = facesContext.getApplication().createConverter(this._converterIdString);
                } else {
                    String converterId = (String)this._converterId.getValue(elContext);
                    converter = facesContext.getApplication().createConverter(converterId);
                }
                if (converter != null && this._binding != null) {
                    this._binding.setValue(elContext, (Object)converter);
                }
            }
            catch (Exception e) {
                throw new JspException("Exception creating converter with converterId: " + this._converterId, (Throwable)e);
            }
        }
        return converter;
    }
}

