/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi;

import jakarta.faces.FacesException;
import jakarta.faces.FacesWrapper;
import jakarta.faces.context.ExternalContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.myfaces.spi.ViewScopeProvider;
import org.apache.myfaces.spi.impl.SpiUtils;

public abstract class ViewScopeProviderFactory
implements FacesWrapper<ViewScopeProviderFactory> {
    protected static final String FACTORY_DEFAULT = "org.apache.myfaces.spi.impl.DefaultViewScopeProviderFactory";
    private static final String FACTORY_KEY = ViewScopeProviderFactory.class.getName();

    public static ViewScopeProviderFactory getViewScopeHandlerFactory(ExternalContext ctx) {
        ViewScopeProviderFactory instance = (ViewScopeProviderFactory)ctx.getApplicationMap().get(FACTORY_KEY);
        if (instance != null) {
            return instance;
        }
        ViewScopeProviderFactory lpf = null;
        try {
            if (System.getSecurityManager() != null) {
                final ExternalContext ectx = ctx;
                lpf = (ViewScopeProviderFactory)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws PrivilegedActionException {
                        return SpiUtils.build(ectx, ViewScopeProviderFactory.class, ViewScopeProviderFactory.FACTORY_DEFAULT);
                    }
                });
            } else {
                lpf = (ViewScopeProviderFactory)SpiUtils.build(ctx, ViewScopeProviderFactory.class, FACTORY_DEFAULT);
            }
        }
        catch (PrivilegedActionException pae) {
            throw new FacesException(pae);
        }
        if (lpf != null) {
            ViewScopeProviderFactory.setViewScopeHandlerFactory(ctx, lpf);
        }
        return lpf;
    }

    public static void setViewScopeHandlerFactory(ExternalContext ctx, ViewScopeProviderFactory instance) {
        ctx.getApplicationMap().put(FACTORY_KEY, instance);
    }

    public abstract ViewScopeProvider getViewScopeHandler(ExternalContext var1);

    @Override
    public ViewScopeProviderFactory getWrapped() {
        return null;
    }

    public abstract void setViewScopeHandler(ExternalContext var1, ViewScopeProvider var2);
}

