/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.managedproperty;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.faces.annotation.ManagedProperty;
import org.apache.myfaces.cdi.managedproperty.ManagedPropertyInfo;
import org.apache.myfaces.cdi.managedproperty.ManagedPropertyProducer;

public class ManagedPropertyExtension
implements Extension {
    private Set<ManagedPropertyInfo> types = new HashSet<ManagedPropertyInfo>();

    public <T> void collect(@Observes ProcessManagedBean<T> event) {
        for (AnnotatedField field : event.getAnnotatedBeanClass().getFields()) {
            this.addAnnotatedTypeIfNecessary((Annotated)field);
        }
    }

    private void addAnnotatedTypeIfNecessary(Annotated annotated) {
        if (annotated.isAnnotationPresent(ManagedProperty.class)) {
            Type type = annotated.getBaseType();
            this.types.add(new ManagedPropertyInfo(type, ((ManagedProperty)annotated.getAnnotation(ManagedProperty.class)).value()));
        }
    }

    public void afterBean(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (ManagedPropertyInfo typeInfo : this.types) {
            afterBeanDiscovery.addBean((Bean)new ManagedPropertyProducer(beanManager, typeInfo));
        }
    }
}

