/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.view;

import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import org.apache.myfaces.cdi.JsfApplicationArtifactHolder;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.cdi.view.ViewScopeBeanHolder;
import org.apache.myfaces.cdi.view.ViewScopeCDIMap;
import org.apache.myfaces.spi.ViewScopeProvider;

public class CDIViewScopeProviderImpl
extends ViewScopeProvider {
    private BeanManager beanManager;
    private ViewScopeBeanHolder viewScopeBeanHolder;

    public CDIViewScopeProviderImpl() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        this.beanManager = CDIUtils.getBeanManager(externalContext);
        Object context = externalContext.getContext();
        if (context instanceof ServletContext) {
            JsfApplicationArtifactHolder appBean = CDIUtils.get(this.beanManager, JsfApplicationArtifactHolder.class);
            appBean.setServletContext((ServletContext)context);
        }
    }

    private ViewScopeBeanHolder getViewScopeBeanHolder() {
        if (this.viewScopeBeanHolder == null) {
            this.viewScopeBeanHolder = CDIUtils.get(this.beanManager, ViewScopeBeanHolder.class);
        }
        return this.viewScopeBeanHolder;
    }

    @Override
    public Map<String, Object> createViewScopeMap(FacesContext facesContext, String viewScopeId) {
        return new ViewScopeCDIMap(facesContext, viewScopeId);
    }

    @Override
    public Map<String, Object> restoreViewScopeMap(FacesContext facesContext, String viewScopeId) {
        return new ViewScopeCDIMap(facesContext, viewScopeId);
    }

    @Override
    public String generateViewScopeId(FacesContext facesContext) {
        return this.getViewScopeBeanHolder().generateUniqueViewScopeId();
    }

    @Override
    public void onSessionDestroyed() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && this.isViewScopeBeanHolderCreated(facesContext)) {
            this.getViewScopeBeanHolder().destroyBeans();
        }
    }

    private boolean isViewScopeBeanHolderCreated(FacesContext facesContext) {
        if (facesContext.getExternalContext().getSession(false) == null || !CDIUtils.isSessionScopeActive(this.beanManager)) {
            return false;
        }
        return facesContext.getExternalContext().getSessionMap().containsKey(ViewScopeBeanHolder.CREATED);
    }

    @Override
    public void destroyViewScopeMap(FacesContext facesContext, String viewScopeId) {
        if (this.isViewScopeBeanHolderCreated(facesContext)) {
            this.getViewScopeBeanHolder().destroyBeans(viewScopeId);
        }
    }
}

