/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesListener;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.faces.event.SystemEventListenerHolder;
import org.apache.myfaces.util.lang.Assert;

public class ApplicationImplEventManager {
    private static final Logger log = Logger.getLogger(ApplicationImplEventManager.class.getName());
    private ConcurrentHashMap<Class<? extends SystemEvent>, List<EventInfo>> globalListeners = new ConcurrentHashMap();
    private ConcurrentHashMap<Class<? extends SystemEvent>, Constructor<? extends SystemEvent>> constructorCache = new ConcurrentHashMap();

    public void publishEvent(FacesContext facesContext, Class<? extends SystemEvent> systemEventClass, Object source) {
        Assert.notNull(source, "source");
        this.publishEvent(facesContext, systemEventClass, source.getClass(), source);
    }

    public void publishEvent(FacesContext facesContext, Class<? extends SystemEvent> systemEventClass, Class<?> sourceBaseType, Object source) {
        Assert.notNull(facesContext, "facesContext");
        Assert.notNull(systemEventClass, "systemEventClass");
        Assert.notNull(source, "source");
        if (!facesContext.isProcessingEvents()) {
            return;
        }
        if (sourceBaseType == null) {
            sourceBaseType = source.getClass();
        }
        try {
            UIViewRoot viewRoot;
            SystemEvent event = null;
            if (source instanceof SystemEventListenerHolder) {
                List listeners = ((SystemEventListenerHolder)source).getListenersForEventClass(systemEventClass);
                event = this.processComponentAttachedListeners(facesContext, listeners, systemEventClass, source, event);
            }
            if ((viewRoot = facesContext.getViewRoot()) != null) {
                List listeners = viewRoot.getViewListenersForEventClass(systemEventClass);
                event = this.processViewAttachedListeners(facesContext, listeners, systemEventClass, source, event);
            }
            List<EventInfo> eventInfos = this.globalListeners.get(systemEventClass);
            event = this.processGlobalListeners(facesContext, eventInfos, systemEventClass, source, event, sourceBaseType);
        }
        catch (AbortProcessingException e) {
            log.log(Level.SEVERE, "Event processing was aborted", e);
        }
    }

    public void subscribeToEvent(Class<? extends SystemEvent> systemEventClass, SystemEventListener listener) {
        this.subscribeToEvent(systemEventClass, null, listener);
    }

    public void subscribeToEvent(Class<? extends SystemEvent> systemEventClass, Class<?> sourceClass, SystemEventListener listener) {
        Assert.notNull(systemEventClass, "systemEventClass");
        Assert.notNull(listener, "listener");
        List<EventInfo> eventInfos = this.globalListeners.get(systemEventClass);
        if (eventInfos == null) {
            eventInfos = new CopyOnWriteArrayList<EventInfo>();
            this.globalListeners.put(systemEventClass, eventInfos);
        }
        EventInfo eventInfo = new EventInfo();
        eventInfo.systemEventClass = systemEventClass;
        eventInfo.sourceClass = sourceClass;
        eventInfo.listener = listener;
        eventInfos.add(eventInfo);
    }

    public void unsubscribeFromEvent(Class<? extends SystemEvent> systemEventClass, SystemEventListener listener) {
        this.unsubscribeFromEvent(systemEventClass, null, listener);
    }

    public void unsubscribeFromEvent(Class<? extends SystemEvent> systemEventClass, Class<?> sourceClass, SystemEventListener listener) {
        Assert.notNull(systemEventClass, "systemEventClass");
        Assert.notNull(listener, "listener");
        List<EventInfo> eventInfos = this.globalListeners.get(systemEventClass);
        if (eventInfos == null || eventInfos.isEmpty()) {
            return;
        }
        if (sourceClass == null) {
            eventInfos.removeIf(e -> ((EventInfo)e).listener.equals(listener));
        } else {
            eventInfos.removeIf(e -> ((EventInfo)e).sourceClass == sourceClass && ((EventInfo)e).listener.equals(listener));
        }
    }

    protected SystemEvent createEvent(Class<? extends SystemEvent> systemEventClass, FacesContext facesContext, Object source) {
        Constructor<? extends SystemEvent> constructor = this.constructorCache.get(systemEventClass);
        if (constructor == null) {
            constructor = this.getConstructor(systemEventClass);
            this.constructorCache.put(systemEventClass, constructor);
        }
        try {
            if (constructor.getParameterTypes().length == 2) {
                return constructor.newInstance(facesContext, source);
            }
            return constructor.newInstance(source);
        }
        catch (Exception e) {
            throw new FacesException("Couldn't instanciate system event of type " + systemEventClass.getName(), (Throwable)e);
        }
    }

    protected Constructor<? extends SystemEvent> getConstructor(Class<? extends SystemEvent> systemEventClass) {
        Constructor<?>[] constructors = systemEventClass.getConstructors();
        Constructor<?> constructor = null;
        for (Constructor<?> c : constructors) {
            if (c.getParameterTypes().length != 2) continue;
            constructor = c;
            break;
        }
        if (constructor == null) {
            for (Constructor<?> c : constructors) {
                if (c.getParameterTypes().length != 1) continue;
                constructor = c;
                break;
            }
        }
        return constructor;
    }

    protected SystemEvent processComponentAttachedListeners(FacesContext facesContext, List<? extends SystemEventListener> listeners, Class<? extends SystemEvent> systemEventClass, Object source, SystemEvent event) {
        if (listeners == null || listeners.isEmpty()) {
            return event;
        }
        int size = listeners.size();
        for (int i = 0; i < size; ++i) {
            SystemEventListener listener = listeners.get(i);
            if (!listener.isListenerForSource(source)) continue;
            if (event == null) {
                event = this.createEvent(systemEventClass, facesContext, source);
            }
            if (!event.isAppropriateListener((FacesListener)listener)) continue;
            event.processListener((FacesListener)listener);
        }
        return event;
    }

    protected SystemEvent processViewAttachedListeners(FacesContext facesContext, List<? extends SystemEventListener> listeners, Class<? extends SystemEvent> systemEventClass, Object source, SystemEvent event) {
        if (listeners == null || listeners.isEmpty()) {
            return event;
        }
        int processedListenerIndex = 0;
        ArrayList<? extends SystemEventListener> listenersCopy = new ArrayList<SystemEventListener>(listeners);
        while (processedListenerIndex < listenersCopy.size()) {
            int i;
            while (processedListenerIndex < listenersCopy.size()) {
                SystemEventListener listener = (SystemEventListener)listenersCopy.get(processedListenerIndex);
                if (listener.isListenerForSource(source)) {
                    if (event == null) {
                        event = this.createEvent(systemEventClass, facesContext, source);
                    }
                    if (event.isAppropriateListener((FacesListener)listener)) {
                        event.processListener((FacesListener)listener);
                    }
                }
                ++processedListenerIndex;
            }
            boolean listChanged = false;
            if (listeners.size() == listenersCopy.size()) {
                for (i = 0; i < listenersCopy.size(); ++i) {
                    if (listenersCopy.get(i) == listeners.get(i)) continue;
                    listChanged = true;
                    break;
                }
            } else {
                listChanged = true;
            }
            if (!listChanged) continue;
            for (i = 0; i < listeners.size(); ++i) {
                SystemEventListener listener = listeners.get(i);
                if (i < listenersCopy.size()) {
                    if (listener.equals(listenersCopy.get(i)) || listenersCopy.contains(listener)) continue;
                    listenersCopy.add((SystemEventListener)listener);
                    continue;
                }
                if (listenersCopy.contains(listener)) continue;
                listenersCopy.add((SystemEventListener)listener);
            }
        }
        return event;
    }

    protected SystemEvent processGlobalListeners(FacesContext facesContext, List<EventInfo> eventInfos, Class<? extends SystemEvent> systemEventClass, Object source, SystemEvent event, Class<?> sourceBaseType) {
        if (eventInfos == null || eventInfos.isEmpty()) {
            return event;
        }
        int size = eventInfos.size();
        for (int i = 0; i < size; ++i) {
            EventInfo eventInfo = eventInfos.get(i);
            if (eventInfo.sourceClass != null && !eventInfo.sourceClass.isAssignableFrom(sourceBaseType) || !eventInfo.listener.isListenerForSource(source)) continue;
            if (event == null) {
                event = this.createEvent(systemEventClass, facesContext, source);
            }
            if (!event.isAppropriateListener((FacesListener)eventInfo.listener)) continue;
            event.processListener((FacesListener)eventInfo.listener);
        }
        return event;
    }

    protected static class EventInfo {
        private Class<? extends SystemEvent> systemEventClass;
        private Class<?> sourceClass;
        private SystemEventListener listener;

        protected EventInfo() {
        }
    }
}

