/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;
import javax.faces.event.ListenerFor;
import javax.faces.event.ListenersFor;
import javax.faces.event.NamedEvent;
import javax.faces.model.FacesDataModel;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.FacesRenderer;
import javax.faces.render.Renderer;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.webapp.FacesServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.HandlesTypes;
import org.apache.myfaces.context.servlet.StartupServletExternalContextImpl;
import org.apache.myfaces.spi.FacesConfigResourceProvider;
import org.apache.myfaces.spi.FacesConfigResourceProviderFactory;
import org.apache.myfaces.util.lang.ClassUtils;
import org.apache.myfaces.webapp.DelegatedFacesServlet;
import org.apache.myfaces.webapp.MyFacesHttpSessionListener;

@HandlesTypes(value={FacesBehavior.class, FacesBehaviorRenderer.class, FacesComponent.class, FacesConverter.class, FacesRenderer.class, FacesValidator.class, FacesDataModel.class, ListenerFor.class, ListenersFor.class, NamedEvent.class, ResourceDependencies.class, ResourceDependency.class, UIComponent.class, Converter.class, Renderer.class, Validator.class})
public class MyFacesContainerInitializer
implements ServletContainerInitializer {
    public static final String FACES_SERVLET_ADDED_ATTRIBUTE = "org.apache.myfaces.DYNAMICALLY_ADDED_FACES_SERVLET";
    public static final String INITIALIZED = "org.apache.myfaces.INITIALIZED";
    public static final String FACES_SERVLET_FOUND = "org.apache.myfaces.FACES_SERVLET_FOUND";
    private static final String FACES_CONFIG_RESOURCE = "/WEB-INF/faces-config.xml";
    private static final Logger log = Logger.getLogger(MyFacesContainerInitializer.class.getName());
    private static final String[] FACES_SERVLET_MAPPINGS = new String[]{"/faces/*", "*.jsf", "*.faces"};
    private static final String[] FACES_SERVLET_FULL_MAPPINGS = new String[]{"/faces/*", "*.jsf", "*.faces", "*.xhtml"};
    private static final String FACES_SERVLET_NAME = "FacesServlet";
    private static final Class<? extends Servlet> FACES_SERVLET_CLASS = FacesServlet.class;
    private static final Class<?> DELEGATED_FACES_SERVLET_CLASS = DelegatedFacesServlet.class;

    public void onStartup(Set<Class<?>> clazzes, ServletContext servletContext) throws ServletException {
        log.log(Level.INFO, "Using " + this.getClass().getName());
        MyFacesHttpSessionListener httpSessionListener = new MyFacesHttpSessionListener();
        servletContext.addListener((EventListener)((Object)httpSessionListener));
        servletContext.setAttribute(MyFacesHttpSessionListener.APPLICATION_MAP_KEY, (Object)httpSessionListener);
        boolean startDireclty = this.shouldStartupRegardless(servletContext);
        if (startDireclty) {
            return;
        }
        if (clazzes != null && !clazzes.isEmpty() || this.isFacesConfigPresent(servletContext)) {
            Object[] mappings;
            Map servlets = servletContext.getServletRegistrations();
            for (Map.Entry servletEntry : servlets.entrySet()) {
                String className = ((ServletRegistration)servletEntry.getValue()).getClassName();
                if (!FACES_SERVLET_CLASS.getName().equals(className) && !this.isDelegatedFacesServlet(className)) continue;
                servletContext.setAttribute(FACES_SERVLET_FOUND, (Object)Boolean.TRUE);
                return;
            }
            ServletRegistration.Dynamic servlet = servletContext.addServlet(FACES_SERVLET_NAME, FACES_SERVLET_CLASS);
            Set conflictMappings = servlet.addMapping((String[])(mappings = this.isAutomaticXhtmlMappingDisabled(servletContext) ? FACES_SERVLET_MAPPINGS : FACES_SERVLET_FULL_MAPPINGS));
            if (conflictMappings != null && !conflictMappings.isEmpty()) {
                HashSet<String> newMappings = new HashSet<String>(Arrays.asList(mappings));
                newMappings.removeAll(conflictMappings);
                mappings = newMappings.toArray(new String[newMappings.size()]);
                servlet.addMapping((String[])mappings);
            }
            if (mappings != null && mappings.length > 0) {
                servletContext.setAttribute(FACES_SERVLET_ADDED_ATTRIBUTE, (Object)Boolean.TRUE);
                log.log(Level.INFO, "Added FacesServlet with mappings=" + Arrays.toString(mappings));
            }
        }
    }

    private boolean shouldStartupRegardless(ServletContext servletContext) {
        try {
            String standaloneStartup = servletContext.getInitParameter("org.apache.myfaces.INITIALIZE_ALWAYS_STANDALONE");
            return "true".equalsIgnoreCase(standaloneStartup);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean shouldSkipJarFacesConfigScan(ServletContext servletContext) {
        try {
            String skipJarScan = servletContext.getInitParameter("org.apache.myfaces.INITIALIZE_SKIP_JAR_FACES_CONFIG_SCAN");
            if (skipJarScan == null) {
                skipJarScan = System.getProperty("org.apache.myfaces.INITIALIZE_SKIP_JAR_FACES_CONFIG_SCAN");
            }
            return "true".equalsIgnoreCase(skipJarScan);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isAutomaticXhtmlMappingDisabled(ServletContext servletContext) {
        try {
            String xhtmlMappingDisabled = servletContext.getInitParameter("javax.faces.DISABLE_FACESSERVLET_TO_XHTML");
            if (xhtmlMappingDisabled == null) {
                xhtmlMappingDisabled = "false";
            }
            return "true".equalsIgnoreCase(xhtmlMappingDisabled);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isFacesConfigPresent(ServletContext servletContext) {
        try {
            StartupServletExternalContextImpl externalContext;
            FacesConfigResourceProviderFactory factory;
            FacesConfigResourceProvider provider;
            Collection<URL> metaInfFacesConfigUrls;
            if (servletContext.getResource(FACES_CONFIG_RESOURCE) != null) {
                return true;
            }
            String configFilesAttrValue = servletContext.getInitParameter("javax.faces.CONFIG_FILES");
            if (configFilesAttrValue != null) {
                String[] configFiles;
                for (String file : configFiles = configFilesAttrValue.split(",")) {
                    if (servletContext.getResource(file.trim()) == null) continue;
                    return true;
                }
            }
            return !this.shouldSkipJarFacesConfigScan(servletContext) && (metaInfFacesConfigUrls = (provider = (factory = FacesConfigResourceProviderFactory.getFacesConfigResourceProviderFactory(externalContext = new StartupServletExternalContextImpl(servletContext, true))).createFacesConfigResourceProvider(externalContext)).getMetaInfConfigurationResources(externalContext)) != null && !metaInfFacesConfigUrls.isEmpty();
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isDelegatedFacesServlet(String className) {
        if (className == null) {
            return false;
        }
        try {
            Class clazz = ClassUtils.classForName(className);
            return DELEGATED_FACES_SERVLET_CLASS.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }
}

