/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.model;

import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.faces.model.FacesDataModel;
import org.apache.myfaces.cdi.model.FacesDataModelInfo;
import org.apache.myfaces.cdi.model.FacesDataModelManager;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.util.lang.ClassUtils;

public class FacesDataModelExtension
implements Extension {
    private Set<FacesDataModelInfo> types = new HashSet<FacesDataModelInfo>();

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        AnnotatedType beanHolder = beanManager.createAnnotatedType(FacesDataModelManager.class);
        event.addAnnotatedType(beanHolder, beanHolder.getJavaClass().getName());
    }

    public <T> void collect(@Observes ProcessManagedBean<T> event) {
        AnnotatedType annotated = event.getAnnotatedBeanClass();
        if (annotated.isAnnotationPresent(FacesDataModel.class)) {
            boolean hasValue;
            FacesDataModel model = (FacesDataModel)annotated.getAnnotation(FacesDataModel.class);
            boolean bl = hasValue = model.forClass() != null;
            if (hasValue) {
                this.types.add(new FacesDataModelInfo(annotated.getBaseType(), model.forClass()));
            }
        }
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation adv, BeanManager beanManager) {
        FacesDataModelManager facesDataModelManager = CDIUtils.get(beanManager, FacesDataModelManager.class);
        for (FacesDataModelInfo typeInfo : this.types) {
            facesDataModelManager.addFacesDataModel(typeInfo.getForClass(), ClassUtils.simpleClassForName(typeInfo.getType().getTypeName()));
        }
        facesDataModelManager.init();
        this.types.clear();
    }
}

