/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.jsf.core;

import java.io.IOException;
import java.io.Serializable;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.view.ActionSource2AttachedObjectHandler;
import javax.faces.view.Location;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletException;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagException;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.view.facelets.FaceletCompositionContext;
import org.apache.myfaces.view.facelets.el.ContextAware;
import org.apache.myfaces.view.facelets.el.ContextAwareELException;

public class SetPropertyActionListenerHandler
extends TagHandler
implements ActionSource2AttachedObjectHandler {
    private final TagAttribute _target;
    private final TagAttribute _value = this.getRequiredAttribute("value");

    public SetPropertyActionListenerHandler(TagConfig config) {
        super(config);
        this._target = this.getRequiredAttribute("target");
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        if (!ComponentHandler.isNew(parent)) {
            return;
        }
        if (parent instanceof ActionSource) {
            this.applyAttachedObject(ctx.getFacesContext(), parent);
        } else if (UIComponent.isCompositeComponent(parent)) {
            FaceletCompositionContext mctx = FaceletCompositionContext.getCurrentInstance(ctx);
            mctx.addAttachedObjectHandler(parent, this);
        } else {
            throw new TagException(this.tag, "Parent is not composite component or of type ActionSource, type is: " + parent);
        }
    }

    @Override
    public void applyAttachedObject(FacesContext context, UIComponent parent) {
        FaceletContext faceletContext = (FaceletContext)((Object)context.getAttributes().get("javax.faces.FACELET_CONTEXT"));
        ActionSource src = (ActionSource)((Object)parent);
        ValueExpression valueExpr = this._value.getValueExpression(faceletContext, Object.class);
        ValueExpression targetExpr = this._target.getValueExpression(faceletContext, Object.class);
        src.addActionListener(new SetPropertyListener(valueExpr, targetExpr));
    }

    @Override
    public String getFor() {
        TagAttribute forAttribute = this.getAttribute("for");
        if (forAttribute == null) {
            return null;
        }
        return forAttribute.getValue();
    }

    private static class SetPropertyListener
    implements ActionListener,
    Serializable {
        private ValueExpression _target;
        private ValueExpression _value;

        public SetPropertyListener() {
        }

        public SetPropertyListener(ValueExpression value, ValueExpression target) {
            this._value = value;
            this._target = target;
        }

        @Override
        public void processAction(ActionEvent evt) throws AbortProcessingException {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ELContext elContext = facesContext.getELContext();
            Object value = this._value.getValue(elContext);
            if (value != null) {
                Class targetType = this._target.getType(elContext);
                ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
                try {
                    value = expressionFactory.coerceToType(value, targetType);
                }
                catch (ELException e) {
                    Location location = null;
                    if (this._value instanceof ContextAware) {
                        ContextAware contextAware = (ContextAware)this._value;
                        location = contextAware.getLocation();
                    }
                    throw new ContextAwareELException(location, this._value.getExpressionString(), "value", e);
                }
            }
            this._target.setValue(elContext, value);
        }
    }
}

