/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.viewstate;

import java.util.Map;
import java.util.Random;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.application.viewstate.CsrfSessionTokenFactory;
import org.apache.myfaces.shade.commons.codec.binary.Hex;
import org.apache.myfaces.shared.util.WebConfigParamUtils;

class RandomCsrfSessionTokenFactory
extends CsrfSessionTokenFactory {
    private final Random random;
    private final int length;

    public RandomCsrfSessionTokenFactory(FacesContext facesContext) {
        this.length = WebConfigParamUtils.getIntegerInitParameter(facesContext.getExternalContext(), "org.apache.myfaces.RANDOM_KEY_IN_CSRF_SESSION_TOKEN_LENGTH", 16);
        this.random = new Random((int)System.nanoTime() + this.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer generateCounterKey(FacesContext facesContext) {
        Integer sequence;
        Object sessionObj;
        ExternalContext externalContext = facesContext.getExternalContext();
        Object object = sessionObj = externalContext.getSession(true);
        synchronized (object) {
            Map map = externalContext.getSessionMap();
            sequence = (Integer)map.get("jsf_sequence");
            sequence = sequence == null || sequence == Integer.MAX_VALUE ? Integer.valueOf(1) : Integer.valueOf(sequence + 1);
            map.put("jsf_sequence", sequence);
        }
        return sequence;
    }

    public byte[] generateKey(FacesContext facesContext) {
        byte[] array = new byte[this.length];
        this.random.nextBytes(array);
        return array;
    }

    @Override
    public String createCryptographicallyStrongTokenFromSession(FacesContext context) {
        byte[] key = this.generateKey(context);
        return new String(Hex.encodeHex(key));
    }
}

