/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared.util.xml;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class MyFacesErrorHandler
implements ErrorHandler {
    private Logger _log;

    public MyFacesErrorHandler(Logger log) {
        this._log = log;
    }

    public void warning(SAXParseException exception) {
        if (this._log.isLoggable(Level.WARNING)) {
            this._log.log(Level.WARNING, this.getMessage(exception), exception);
        }
    }

    public void error(SAXParseException exception) {
        this._log.log(Level.SEVERE, this.getMessage(exception), exception);
    }

    public void fatalError(SAXParseException exception) {
        this._log.log(Level.SEVERE, this.getMessage(exception), exception);
    }

    private String getMessage(SAXParseException exception) {
        StringBuilder buf = new StringBuilder();
        buf.append("SAXParseException at");
        buf.append(" URI=");
        buf.append(exception.getSystemId());
        buf.append(" Line=");
        buf.append(exception.getLineNumber());
        buf.append(" Column=");
        buf.append(exception.getColumnNumber());
        return buf.toString();
    }
}

