/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application.pss;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.application.jsp.JspViewHandlerImpl;
import org.apache.myfaces.application.pss.BufferedStringWriter;
import org.apache.myfaces.application.pss.EncodeAllComponentUtil;
import org.apache.myfaces.portlet.PortletUtil;
import org.apache.myfaces.shared_impl.webapp.webxml.ServletMapping;
import org.apache.myfaces.shared_impl.webapp.webxml.WebXml;
import org.apache.myfaces.util.DebugUtils;

public class PssJspViewHandlerImpl
extends ViewHandler {
    private static final Log log = LogFactory.getLog((Class)JspViewHandlerImpl.class);
    private ViewHandler oldViewHandler = null;
    private static final String PARTIAL_STATE_SAVING_METHOD_PARAM_NAME = "javax.faces.PARTIAL_STATE_SAVING_METHOD";
    private static final String PARTIAL_STATE_SAVING_METHOD_ON = "true";
    private static final String PARTIAL_STATE_SAVING_METHOD_OFF = "false";
    private Boolean _partialStateSaving = null;
    private int bufSize = 32;

    private boolean isPartialStateSavingOn(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (this._partialStateSaving != null) {
            return this._partialStateSaving;
        }
        String stateSavingMethod = context.getExternalContext().getInitParameter(PARTIAL_STATE_SAVING_METHOD_PARAM_NAME);
        if (stateSavingMethod == null) {
            this._partialStateSaving = Boolean.FALSE;
            context.getExternalContext().log("No context init parameter 'javax.faces.PARTIAL_STATE_SAVING_METHOD' found; no partial state saving method defined, assuming default partial state saving method off.");
        } else if (stateSavingMethod.equals(PARTIAL_STATE_SAVING_METHOD_ON)) {
            this._partialStateSaving = Boolean.TRUE;
        } else if (stateSavingMethod.equals(PARTIAL_STATE_SAVING_METHOD_OFF)) {
            this._partialStateSaving = Boolean.FALSE;
        } else {
            this._partialStateSaving = Boolean.FALSE;
            context.getExternalContext().log("Illegal partial state saving method '" + stateSavingMethod + "', default partial state saving will be used (partial state saving off).");
        }
        return this._partialStateSaving;
    }

    private ViewHandler getOldViewHandler() {
        if (this.oldViewHandler == null) {
            this.oldViewHandler = new JspViewHandlerImpl();
        }
        return this.oldViewHandler;
    }

    public PssJspViewHandlerImpl() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"New partial ViewHandler instance created");
        }
    }

    public Locale calculateLocale(FacesContext context) {
        return this.getOldViewHandler().calculateLocale(context);
    }

    public String calculateRenderKitId(FacesContext context) {
        return this.getOldViewHandler().calculateRenderKitId(context);
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        return this.getOldViewHandler().createView(context, viewId);
    }

    public String getActionURL(FacesContext context, String viewId) {
        return this.getOldViewHandler().getActionURL(context, viewId);
    }

    public String getResourceURL(FacesContext context, String path) {
        return this.getOldViewHandler().getResourceURL(context, path);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        if (!this.isPartialStateSavingOn(context)) {
            log.fatal((Object)"Partial state saving ViewHandler is installed, but partial state saving is not enabled. Please enable partial state saving or use another ViewHandler.");
        }
        UIViewRoot root = null;
        Application application = context.getApplication();
        ViewHandler applicationViewHandler = application.getViewHandler();
        String renderKitId = applicationViewHandler.calculateRenderKitId(context);
        root = context.getApplication().getStateManager().restoreView(context, viewId, renderKitId);
        return root;
    }

    public void writeState(FacesContext context) throws IOException {
        this.getOldViewHandler().writeState(context);
    }

    public void renderView(FacesContext facesContext, UIViewRoot viewToRender) throws IOException, FacesException {
        HttpSession session;
        ResponseWriter responseWriter;
        if (viewToRender == null) {
            log.fatal((Object)"viewToRender must not be null");
            throw new NullPointerException("viewToRender must not be null");
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        String viewId = facesContext.getViewRoot().getViewId();
        if (PortletUtil.isPortletRequest(facesContext)) {
            externalContext.dispatch(viewId);
            return;
        }
        ServletMapping servletMapping = PssJspViewHandlerImpl.getServletMapping(externalContext);
        if (servletMapping != null && servletMapping.isExtensionMapping()) {
            String defaultSuffix = externalContext.getInitParameter("javax.faces.DEFAULT_SUFFIX");
            String suffix = defaultSuffix != null ? defaultSuffix : ".jsp";
            DebugUtils.assertError(suffix.charAt(0) == '.', log, "Default suffix must start with a dot!");
            if (!viewId.endsWith(suffix)) {
                int slashPos = viewId.lastIndexOf(47);
                int extensionPos = viewId.lastIndexOf(46);
                if (extensionPos == -1 || extensionPos <= slashPos) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Current viewId has no extension, appending default suffix " + suffix));
                    }
                    viewId = viewId + suffix;
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("Replacing extension of current viewId by suffix " + suffix));
                    }
                    viewId = viewId.substring(0, extensionPos) + suffix;
                }
                facesContext.getViewRoot().setViewId(viewId);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Dispatching to " + viewId));
        }
        if (externalContext.getResponse() instanceof ServletResponse) {
            ServletResponse response = (ServletResponse)externalContext.getResponse();
            response.setLocale(viewToRender.getLocale());
        }
        ResponseWriter oldWriter = facesContext.getResponseWriter();
        HttpServletRequest request = (HttpServletRequest)externalContext.getRequest();
        HttpServletResponse response = (HttpServletResponse)externalContext.getResponse();
        RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderFactory.getRenderKit(facesContext, viewToRender.getRenderKitId());
        BufferedStringWriter strWriter = new BufferedStringWriter(facesContext, this.bufSize);
        ResponseWriter newWriter = null != oldWriter ? oldWriter.cloneWithWriter((Writer)strWriter) : renderKit.createResponseWriter((Writer)strWriter, null, request.getCharacterEncoding());
        facesContext.setResponseWriter(newWriter);
        if (null != oldWriter) {
            responseWriter = oldWriter.cloneWithWriter((Writer)response.getWriter());
        } else {
            response.reset();
            responseWriter = newWriter.cloneWithWriter((Writer)response.getWriter());
        }
        newWriter.startDocument();
        newWriter.flush();
        EncodeAllComponentUtil.encodeAll(facesContext, (UIComponent)viewToRender);
        newWriter.flush();
        newWriter.endDocument();
        facesContext.setResponseWriter(responseWriter);
        strWriter.flushToWriter((Writer)responseWriter);
        if (oldWriter != null) {
            facesContext.setResponseWriter(oldWriter);
        }
        if (facesContext.getExternalContext().getResponse() instanceof ServletResponseWrapper) {
            ((ServletResponseWrapper)facesContext.getExternalContext().getResponse()).setContentType("text/html");
        }
        if (externalContext.getRequest() instanceof HttpServletRequest && (session = request.getSession(false)) != null) {
            session.setAttribute("javax.faces.request.charset", (Object)response.getCharacterEncoding());
        }
    }

    private static ServletMapping getServletMapping(ExternalContext externalContext) {
        String servletPath = externalContext.getRequestServletPath();
        String requestPathInfo = externalContext.getRequestPathInfo();
        WebXml webxml = WebXml.getWebXml(externalContext);
        List mappings = webxml.getFacesServletMappings();
        if (requestPathInfo == null) {
            int size = mappings.size();
            for (int i = 0; i < size; ++i) {
                ServletMapping servletMapping = (ServletMapping)mappings.get(i);
                String urlpattern = servletMapping.getUrlPattern();
                String extension = urlpattern.substring(1, urlpattern.length());
                if (servletPath.endsWith(extension)) {
                    return servletMapping;
                }
                if (!servletPath.equals(urlpattern)) continue;
                return servletMapping;
            }
        } else {
            int size = mappings.size();
            for (int i = 0; i < size; ++i) {
                ServletMapping servletMapping = (ServletMapping)mappings.get(i);
                String urlpattern = servletMapping.getUrlPattern();
                if (!servletPath.equals(urlpattern = urlpattern.substring(0, urlpattern.length() - 2))) continue;
                return servletMapping;
            }
        }
        if (mappings.size() > 0) {
            return (ServletMapping)mappings.get(0);
        }
        log.warn((Object)"no faces servlet mappings found");
        return null;
    }
}

