/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.exporter.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlDataTable;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.myfaces.commons.exporter.util.ComponentUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExcelExporterUtil {
    public static void generateEXCEL(FacesContext facesContext, HttpServletResponse response, String fileName, HtmlDataTable dataTable) throws IOException {
        if (fileName == null) {
            fileName = dataTable.getId();
        }
        HSSFWorkbook generatedExcel = ExcelExporterUtil.generateExcelTableModel(facesContext, dataTable);
        ExcelExporterUtil.writeExcelToResponse(response, generatedExcel, fileName);
    }

    private static void addColumnHeaders(HSSFSheet sheet, List columns) {
        HSSFRow rowHeader = sheet.createRow(0);
        for (int i = 0; i < columns.size(); ++i) {
            UIColumn column = (UIColumn)columns.get(i);
            ExcelExporterUtil.addColumnValue(rowHeader, column.getHeader(), i);
        }
    }

    private static List getColumns(HtmlDataTable table) {
        ArrayList<UIComponent> columns = new ArrayList<UIComponent>();
        for (int i = 0; i < table.getChildCount(); ++i) {
            UIComponent child = (UIComponent)table.getChildren().get(i);
            if (!(child instanceof UIColumn)) continue;
            columns.add(child);
        }
        return columns;
    }

    private static void addColumnValue(HSSFRow rowHeader, UIComponent component, int index) {
        HSSFCell cell = rowHeader.createCell((short)index);
        cell.setEncoding((short)1);
        if (component instanceof ValueHolder) {
            String stringValue = ComponentUtils.getStringValue(FacesContext.getCurrentInstance(), component);
            cell.setCellValue(stringValue);
        }
    }

    private static void addColumnValue(HSSFRow rowHeader, String value, int index) {
        HSSFCell cell = rowHeader.createCell((short)index);
        cell.setEncoding((short)1);
        cell.setCellValue(value);
    }

    private static void generateTableContent(FacesContext facesContext, HSSFSheet sheet, List columns, HtmlDataTable dataTable) {
        int numberOfColumns = columns.size();
        int numberOfRows = dataTable.getRowCount();
        int startFrom = 0;
        int currentIndex = 1;
        int endAt = numberOfRows;
        for (int i = startFrom; i < endAt; ++i) {
            dataTable.setRowIndex(i);
            HSSFRow row = sheet.createRow(currentIndex++);
            for (int j = 0; j < numberOfColumns; ++j) {
                UIColumn column = (UIColumn)columns.get(j);
                String cellValue = "";
                for (int k = 0; k < column.getChildren().size(); ++k) {
                    if (!(column.getChildren().get(k) instanceof ValueHolder)) continue;
                    cellValue = cellValue + ((ValueHolder)column.getChildren().get(k)).getValue();
                }
                ExcelExporterUtil.addColumnValue(row, cellValue, j);
            }
        }
    }

    private static void writeExcelToResponse(HttpServletResponse response, HSSFWorkbook generatedExcel, String fileName) throws IOException {
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "must-revalidate, post-check=0, pre-check=0");
        response.setHeader("Pragma", "public");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xls");
        generatedExcel.write((OutputStream)response.getOutputStream());
    }

    private static HSSFWorkbook generateExcelTableModel(FacesContext facesContext, HtmlDataTable dataTable) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(dataTable.getId());
        List columns = ExcelExporterUtil.getColumns(dataTable);
        int currentRowIndex = dataTable.getRowIndex();
        ExcelExporterUtil.addColumnHeaders(sheet, columns);
        ExcelExporterUtil.generateTableContent(facesContext, sheet, columns, dataTable);
        dataTable.setRowIndex(currentRowIndex);
        return workbook;
    }
}

