/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.shell;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.shell.InvertedShell;
import org.apache.sshd.server.shell.InvertedShellWrapper;
import org.apache.sshd.server.shell.ProcessShell;
import org.apache.sshd.server.shell.ShellFactory;

public class ProcessShellFactory
extends AbstractLoggingBean
implements ShellFactory {
    private String command;
    private List<String> elements;

    public ProcessShellFactory() {
        this.command = "";
        this.elements = Collections.emptyList();
    }

    public ProcessShellFactory(String command, String ... elements) {
        this(command, GenericUtils.isEmpty((Object[])elements) ? Collections.emptyList() : Arrays.asList(elements));
    }

    public ProcessShellFactory(String command, List<String> elements) {
        this.command = ValidateUtils.checkNotNullAndNotEmpty((String)command, (String)"No command");
        this.elements = (List)ValidateUtils.checkNotNullAndNotEmpty(elements, (String)"No parsed elements", (Object[])new Object[0]);
    }

    public String getCommand() {
        return this.command;
    }

    public List<String> getElements() {
        return this.elements;
    }

    public void setCommand(String command, String ... elements) {
        this.setCommand(command, GenericUtils.isEmpty((Object[])elements) ? Collections.emptyList() : Arrays.asList(elements));
    }

    public void setCommand(String command, List<String> elements) {
        this.command = ValidateUtils.checkNotNullAndNotEmpty((String)command, (String)"No command");
        this.elements = (List)ValidateUtils.checkNotNullAndNotEmpty(elements, (String)"No parsed elements", (Object[])new Object[0]);
    }

    @Override
    public Command createShell(ChannelSession channel) {
        InvertedShell shell = this.createInvertedShell(channel);
        return new InvertedShellWrapper(shell);
    }

    protected InvertedShell createInvertedShell(ChannelSession channel) {
        return new ProcessShell(this.resolveEffectiveCommand(channel, this.getCommand(), this.getElements()));
    }

    protected List<String> resolveEffectiveCommand(ChannelSession channel, String rawCommand, List<String> parsedElements) {
        if (!OsUtils.isWin32()) {
            return (List)ValidateUtils.checkNotNullAndNotEmpty(parsedElements, (String)"No parsed command elements", (Object[])new Object[0]);
        }
        if (GenericUtils.size(parsedElements) <= 1) {
            return (List)ValidateUtils.checkNotNullAndNotEmpty(parsedElements, (String)"No parsed command elements", (Object[])new Object[0]);
        }
        String cmdName = parsedElements.get(0);
        if ("cmd.exe".equalsIgnoreCase(cmdName)) {
            return (List)ValidateUtils.checkNotNullAndNotEmpty(parsedElements, (String)"No parsed command elements", (Object[])new Object[0]);
        }
        return Arrays.asList("cmd.exe", "/C", ValidateUtils.checkNotNullAndNotEmpty((String)rawCommand, (String)"No command"));
    }
}

