/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class TcpipClientChannel
extends AbstractClientChannel {
    private final Type typeEnum;
    private final IoSession serverSession;
    private final SshdSocketAddress remote;

    public TcpipClientChannel(Type type, IoSession serverSession, SshdSocketAddress remote) {
        super(type == Type.Direct ? "direct-tcpip" : "forwarded-tcpip");
        this.typeEnum = type;
        this.serverSession = serverSession;
        this.remote = remote;
    }

    public OpenFuture getOpenFuture() {
        return this.openFuture;
    }

    @Override
    public synchronized OpenFuture open() throws IOException {
        InetSocketAddress dst;
        InetSocketAddress src;
        switch (this.typeEnum) {
            case Direct: {
                src = (InetSocketAddress)this.serverSession.getRemoteAddress();
                dst = this.remote.toInetSocketAddress();
                break;
            }
            case Forwarded: {
                src = (InetSocketAddress)this.serverSession.getRemoteAddress();
                dst = (InetSocketAddress)this.serverSession.getLocalAddress();
                break;
            }
            default: {
                throw new SshException("Unknown client channel type: " + (Object)((Object)this.typeEnum));
            }
        }
        if (this.closeFuture.isClosed()) {
            throw new SshException("Session has been closed");
        }
        this.openFuture = new DefaultOpenFuture(src, this.lock);
        if (this.log.isDebugEnabled()) {
            this.log.debug("open({}) send SSH_MSG_CHANNEL_OPEN", (Object)this);
        }
        Session session = this.getSession();
        InetAddress srcAddress = src.getAddress();
        String srcHost = srcAddress.getHostAddress();
        InetAddress dstAddress = dst.getAddress();
        String dstHost = dstAddress.getHostAddress();
        Window wLocal = this.getLocalWindow();
        Buffer buffer = session.createBuffer((byte)90, this.type.length() + srcHost.length() + dstHost.length() + 64);
        buffer.putString(this.type);
        buffer.putInt(this.getId());
        buffer.putInt(wLocal.getSize());
        buffer.putInt(wLocal.getPacketSize());
        buffer.putString(dstHost);
        buffer.putInt(dst.getPort());
        buffer.putString(srcHost);
        buffer.putInt(src.getPort());
        this.writePacket(buffer);
        return this.openFuture;
    }

    @Override
    protected synchronized void doOpen() throws IOException {
        if (this.streaming == ClientChannel.Streaming.Async) {
            throw new IllegalArgumentException("Asynchronous streaming isn't supported yet on this channel");
        }
        this.invertedIn = this.out = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().sequential(this.serverSession, super.getInnerCloseable()).build();
    }

    @Override
    protected synchronized void doWriteData(byte[] data, int off, long len) throws IOException {
        ValidateUtils.checkTrue(len <= Integer.MAX_VALUE, "Data length exceeds int boundaries: %d", len);
        ByteArrayBuffer buf = ByteArrayBuffer.getCompactClone(data, off, (int)len);
        Window wLocal = this.getLocalWindow();
        wLocal.consumeAndCheck(len);
        this.serverSession.writePacket(buf);
    }

    @Override
    protected void doWriteExtendedData(byte[] data, int off, long len) throws IOException {
        throw new UnsupportedOperationException(this.type + "Tcpip channel does not support extended data");
    }

    public static enum Type {
        Direct,
        Forwarded;

    }
}

