/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.util.HashMap;
import java.util.Map;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFStructElem;
import org.apache.fop.render.pdf.PDFEventProducer;
import org.w3c.dom.Node;

final class FOToPDFRoleMap {
    private static final Map STANDARD_STRUCTURE_TYPES;
    private static final Map DEFAULT_MAPPINGS;
    private static final PDFName THEAD;
    private static final PDFName NON_STRUCT;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static void addStructureType(String structureType) {
        STANDARD_STRUCTURE_TYPES.put(structureType, new PDFName(structureType));
    }

    private static void addMapping(String fo, String structureType) {
        PDFName type = (PDFName)STANDARD_STRUCTURE_TYPES.get(structureType);
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        FOToPDFRoleMap.addMapping(fo, new SimpleMapper(type));
    }

    private static void addMapping(String fo, Mapper mapper) {
        DEFAULT_MAPPINGS.put(fo, mapper);
    }

    public static PDFName mapFormattingObject(String fo, PDFObject parent) {
        Mapper mapper = (Mapper)DEFAULT_MAPPINGS.get(fo);
        if (mapper != null) {
            return mapper.getStructureType(parent);
        }
        return NON_STRUCT;
    }

    public static PDFName mapFormattingObject(Node fo, PDFObject parent, EventBroadcaster eventBroadcaster) {
        PDFName type = null;
        Node role = fo.getAttributes().getNamedItemNS(null, "role");
        if (role == null) {
            type = FOToPDFRoleMap.mapFormattingObject(fo.getLocalName(), parent);
        } else {
            String customType = role.getNodeValue();
            type = (PDFName)STANDARD_STRUCTURE_TYPES.get(customType);
            if (type == null) {
                String foName = fo.getLocalName();
                type = FOToPDFRoleMap.mapFormattingObject(foName, parent);
                PDFEventProducer.Provider.get(eventBroadcaster).nonStandardStructureType(fo, foName, customType, type.toString().substring(1));
            }
        }
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        return type;
    }

    private FOToPDFRoleMap() {
    }

    static {
        $assertionsDisabled = !FOToPDFRoleMap.class.desiredAssertionStatus();
        STANDARD_STRUCTURE_TYPES = new HashMap();
        DEFAULT_MAPPINGS = new HashMap();
        FOToPDFRoleMap.addStructureType("Document");
        FOToPDFRoleMap.addStructureType("Part");
        FOToPDFRoleMap.addStructureType("Art");
        FOToPDFRoleMap.addStructureType("Sect");
        FOToPDFRoleMap.addStructureType("Div");
        FOToPDFRoleMap.addStructureType("BlockQuote");
        FOToPDFRoleMap.addStructureType("Caption");
        FOToPDFRoleMap.addStructureType("TOC");
        FOToPDFRoleMap.addStructureType("TOCI");
        FOToPDFRoleMap.addStructureType("Index");
        FOToPDFRoleMap.addStructureType("NonStruct");
        FOToPDFRoleMap.addStructureType("Private");
        FOToPDFRoleMap.addStructureType("H");
        FOToPDFRoleMap.addStructureType("H1");
        FOToPDFRoleMap.addStructureType("H2");
        FOToPDFRoleMap.addStructureType("H3");
        FOToPDFRoleMap.addStructureType("H4");
        FOToPDFRoleMap.addStructureType("H5");
        FOToPDFRoleMap.addStructureType("H6");
        FOToPDFRoleMap.addStructureType("P");
        FOToPDFRoleMap.addStructureType("L");
        FOToPDFRoleMap.addStructureType("LI");
        FOToPDFRoleMap.addStructureType("Lbl");
        FOToPDFRoleMap.addStructureType("LBody");
        FOToPDFRoleMap.addStructureType("Table");
        FOToPDFRoleMap.addStructureType("TR");
        FOToPDFRoleMap.addStructureType("TH");
        FOToPDFRoleMap.addStructureType("TD");
        FOToPDFRoleMap.addStructureType("THead");
        FOToPDFRoleMap.addStructureType("TBody");
        FOToPDFRoleMap.addStructureType("TFoot");
        FOToPDFRoleMap.addStructureType("Span");
        FOToPDFRoleMap.addStructureType("Quote");
        FOToPDFRoleMap.addStructureType("Note");
        FOToPDFRoleMap.addStructureType("Reference");
        FOToPDFRoleMap.addStructureType("BibEntry");
        FOToPDFRoleMap.addStructureType("Code");
        FOToPDFRoleMap.addStructureType("Link");
        FOToPDFRoleMap.addStructureType("Annot");
        FOToPDFRoleMap.addStructureType("Ruby");
        FOToPDFRoleMap.addStructureType("RB");
        FOToPDFRoleMap.addStructureType("RT");
        FOToPDFRoleMap.addStructureType("RP");
        FOToPDFRoleMap.addStructureType("Warichu");
        FOToPDFRoleMap.addStructureType("WT");
        FOToPDFRoleMap.addStructureType("WP");
        FOToPDFRoleMap.addStructureType("Figure");
        FOToPDFRoleMap.addStructureType("Formula");
        FOToPDFRoleMap.addStructureType("Form");
        NON_STRUCT = (PDFName)STANDARD_STRUCTURE_TYPES.get("NonStruct");
        if (!$assertionsDisabled && NON_STRUCT == null) {
            throw new AssertionError();
        }
        THEAD = (PDFName)STANDARD_STRUCTURE_TYPES.get("THead");
        if (!$assertionsDisabled && THEAD == null) {
            throw new AssertionError();
        }
        FOToPDFRoleMap.addMapping("root", "Document");
        FOToPDFRoleMap.addMapping("page-sequence", "Part");
        FOToPDFRoleMap.addMapping("flow", "Sect");
        FOToPDFRoleMap.addMapping("static-content", "Sect");
        FOToPDFRoleMap.addMapping("block", "P");
        FOToPDFRoleMap.addMapping("block-container", "Div");
        FOToPDFRoleMap.addMapping("character", "Span");
        FOToPDFRoleMap.addMapping("external-graphic", "Figure");
        FOToPDFRoleMap.addMapping("instream-foreign-object", "Figure");
        FOToPDFRoleMap.addMapping("inline", "Span");
        FOToPDFRoleMap.addMapping("inline-container", "Div");
        FOToPDFRoleMap.addMapping("page-number", "Quote");
        FOToPDFRoleMap.addMapping("page-number-citation", "Quote");
        FOToPDFRoleMap.addMapping("page-number-citation-last", "Quote");
        FOToPDFRoleMap.addMapping("table-and-caption", "Div");
        FOToPDFRoleMap.addMapping("table", "Table");
        FOToPDFRoleMap.addMapping("table-caption", "Caption");
        FOToPDFRoleMap.addMapping("table-header", "THead");
        FOToPDFRoleMap.addMapping("table-footer", "TFoot");
        FOToPDFRoleMap.addMapping("table-body", "TBody");
        FOToPDFRoleMap.addMapping("table-row", "TR");
        FOToPDFRoleMap.addMapping("table-cell", new TableCellMapper());
        FOToPDFRoleMap.addMapping("list-block", "L");
        FOToPDFRoleMap.addMapping("list-item", "LI");
        FOToPDFRoleMap.addMapping("list-item-body", "LBody");
        FOToPDFRoleMap.addMapping("list-item-label", "Lbl");
        FOToPDFRoleMap.addMapping("basic-link", "Link");
        FOToPDFRoleMap.addMapping("float", "Div");
        FOToPDFRoleMap.addMapping("footnote", "Note");
        FOToPDFRoleMap.addMapping("footnote-body", "Sect");
        FOToPDFRoleMap.addMapping("wrapper", "Span");
        FOToPDFRoleMap.addMapping("marker", "Private");
    }

    private static class TableCellMapper
    implements Mapper {
        static final /* synthetic */ boolean $assertionsDisabled;

        private TableCellMapper() {
        }

        public PDFName getStructureType(PDFObject parent) {
            PDFStructElem grandParent = ((PDFStructElem)parent).getParentStructElem();
            PDFName type = THEAD.equals(grandParent.getStructureType()) ? (PDFName)STANDARD_STRUCTURE_TYPES.get("TH") : (PDFName)STANDARD_STRUCTURE_TYPES.get("TD");
            if (!$assertionsDisabled && type == null) {
                throw new AssertionError();
            }
            return type;
        }

        static {
            $assertionsDisabled = !(class$org$apache$fop$render$pdf$FOToPDFRoleMap == null ? (class$org$apache$fop$render$pdf$FOToPDFRoleMap = FOToPDFRoleMap.class$("org.apache.fop.render.pdf.FOToPDFRoleMap")) : class$org$apache$fop$render$pdf$FOToPDFRoleMap).desiredAssertionStatus();
        }
    }

    private static class SimpleMapper
    implements Mapper {
        private PDFName structureType;

        public SimpleMapper(PDFName structureType) {
            this.structureType = structureType;
        }

        public PDFName getStructureType(PDFObject parent) {
            return this.structureType;
        }
    }

    private static interface Mapper {
        public PDFName getStructureType(PDFObject var1);
    }
}

