/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.FieldInfo;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.internal.SourceFieldMapper;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.highlight.HighlightField;
import org.elasticsearch.search.highlight.Highlighter;
import org.elasticsearch.search.highlight.HighlighterContext;
import org.elasticsearch.search.highlight.HighlighterParseElement;
import org.elasticsearch.search.highlight.Highlighters;
import org.elasticsearch.search.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.SearchContext;

public class HighlightPhase
extends AbstractComponent
implements FetchSubPhase {
    private final Highlighters highlighters;

    @Inject
    public HighlightPhase(Settings settings, Highlighters highlighters) {
        super(settings);
        this.highlighters = highlighters;
    }

    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.of("highlight", new HighlighterParseElement());
    }

    @Override
    public boolean hitsExecutionNeeded(SearchContext context) {
        return false;
    }

    @Override
    public void hitsExecute(SearchContext context, InternalSearchHit[] hits) throws ElasticsearchException {
    }

    @Override
    public boolean hitExecutionNeeded(SearchContext context) {
        return context.highlight() != null;
    }

    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) throws ElasticsearchException {
        HashMap<String, HighlightField> highlightFields = Maps.newHashMap();
        for (SearchContextHighlight.Field field : context.highlight().fields()) {
            SourceFieldMapper sourceFieldMapper;
            Set<String> fieldNamesToHighlight;
            if (Regex.isSimpleMatchPattern(field.field())) {
                DocumentMapper documentMapper = context.mapperService().documentMapper(hitContext.hit().type());
                fieldNamesToHighlight = documentMapper.mappers().simpleMatchToFullName(field.field());
            } else {
                fieldNamesToHighlight = ImmutableSet.of(field.field());
            }
            if (context.highlight().forceSource(field) && !(sourceFieldMapper = context.mapperService().documentMapper(hitContext.hit().type()).sourceMapper()).enabled()) {
                throw new ElasticsearchIllegalArgumentException("source is forced for fields " + fieldNamesToHighlight + " but type [" + hitContext.hit().type() + "] has disabled _source");
            }
            for (String fieldName : fieldNamesToHighlight) {
                Highlighter highlighter;
                FieldMapper<?> fieldMapper = this.getMapperForField(fieldName, context, hitContext);
                if (fieldMapper == null) continue;
                String highlighterType = field.fieldOptions().highlighterType();
                if (highlighterType == null) {
                    boolean useFastVectorHighlighter;
                    boolean bl = useFastVectorHighlighter = fieldMapper.fieldType().storeTermVectors() && fieldMapper.fieldType().storeTermVectorOffsets() && fieldMapper.fieldType().storeTermVectorPositions();
                    highlighterType = useFastVectorHighlighter ? "fvh" : (fieldMapper.fieldType().indexOptions() == FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS ? "postings" : "plain");
                }
                if ((highlighter = this.highlighters.get(highlighterType)) == null) {
                    throw new ElasticsearchIllegalArgumentException("unknown highlighter type [" + highlighterType + "] for the field [" + fieldName + "]");
                }
                HighlighterContext.HighlightQuery highlightQuery = field.fieldOptions().highlightQuery() == null ? new HighlighterContext.HighlightQuery(context.parsedQuery().query(), context.query(), context.queryRewritten()) : new HighlighterContext.HighlightQuery(field.fieldOptions().highlightQuery(), field.fieldOptions().highlightQuery(), false);
                HighlighterContext highlighterContext = new HighlighterContext(fieldName, field, fieldMapper, context, hitContext, highlightQuery);
                HighlightField highlightField = highlighter.highlight(highlighterContext);
                if (highlightField == null) continue;
                highlightFields.put(highlightField.name(), highlightField);
            }
        }
        hitContext.hit().highlightFields(highlightFields);
    }

    private FieldMapper<?> getMapperForField(String fieldName, SearchContext searchContext, FetchSubPhase.HitContext hitContext) {
        DocumentMapper documentMapper = searchContext.mapperService().documentMapper(hitContext.hit().type());
        FieldMapper mapper = documentMapper.mappers().smartNameFieldMapper(fieldName);
        if (mapper == null) {
            MapperService.SmartNameFieldMappers fullMapper = searchContext.mapperService().smartName(fieldName);
            if (fullMapper == null || !fullMapper.hasDocMapper() || fullMapper.docMapper().type().equals(hitContext.hit().type())) {
                return null;
            }
            mapper = fullMapper.mapper();
        }
        return mapper;
    }
}

