/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongsRef;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.IntArray;
import org.elasticsearch.index.fielddata.BytesValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;

abstract class SortedSetDVAtomicFieldData {
    private final AtomicReader reader;
    private final String field;
    private volatile IntArray hashes;

    SortedSetDVAtomicFieldData(AtomicReader reader, String field) {
        this.reader = reader;
        this.field = field;
    }

    public boolean isMultiValued() {
        return true;
    }

    public int getNumDocs() {
        return this.reader.maxDoc();
    }

    public long getNumberUniqueValues() {
        SortedSetDocValues values = SortedSetDVAtomicFieldData.getValuesNoException(this.reader, this.field);
        return values.getValueCount();
    }

    public long getMemorySizeInBytes() {
        return -1L;
    }

    public void close() {
    }

    public BytesValues.WithOrdinals getBytesValues(boolean needsHashes) {
        SortedSetDocValues values = SortedSetDVAtomicFieldData.getValuesNoException(this.reader, this.field);
        return new SortedSetValues(this.reader, this.field, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BytesValues.WithOrdinals getHashedBytesValues() {
        SortedSetDocValues values = SortedSetDVAtomicFieldData.getValuesNoException(this.reader, this.field);
        if (this.hashes == null) {
            SortedSetDVAtomicFieldData sortedSetDVAtomicFieldData = this;
            synchronized (sortedSetDVAtomicFieldData) {
                if (this.hashes == null) {
                    long valueCount = values.getValueCount();
                    IntArray hashes = BigArrays.newIntArray(1L + valueCount);
                    BytesRef scratch = new BytesRef(16);
                    hashes.set(0L, scratch.hashCode());
                    for (long i = 0L; i < valueCount; ++i) {
                        values.lookupOrd(i, scratch);
                        hashes.set(1L + i, scratch.hashCode());
                    }
                    this.hashes = hashes;
                }
            }
        }
        return new SortedSetHashedValues(this.reader, this.field, values, this.hashes);
    }

    private static SortedSetDocValues getValuesNoException(AtomicReader reader, String field) {
        try {
            SortedSetDocValues values = reader.getSortedSetDocValues(field);
            if (values == null) {
                assert (reader.getFieldInfos().fieldInfo(field) == null);
                values = SortedSetDocValues.EMPTY;
            }
            return values;
        }
        catch (IOException e) {
            throw new ElasticsearchIllegalStateException("Couldn't load doc values", e);
        }
    }

    static class SortedSetDocs
    implements Ordinals.Docs {
        private final SortedSetOrdinals ordinals;
        private final SortedSetDocValues values;
        private final LongsRef longScratch;
        private int ordIndex = Integer.MAX_VALUE;
        private long currentOrdinal = -1L;

        SortedSetDocs(SortedSetOrdinals ordinals, SortedSetDocValues values) {
            this.ordinals = ordinals;
            this.values = values;
            this.longScratch = new LongsRef(8);
        }

        @Override
        public Ordinals ordinals() {
            return this.ordinals;
        }

        @Override
        public int getNumDocs() {
            return this.ordinals.getNumDocs();
        }

        @Override
        public long getNumOrds() {
            return this.ordinals.getNumOrds();
        }

        @Override
        public long getMaxOrd() {
            return this.ordinals.getMaxOrd();
        }

        @Override
        public boolean isMultiValued() {
            return this.ordinals.isMultiValued();
        }

        @Override
        public long getOrd(int docId) {
            this.values.setDocument(docId);
            this.currentOrdinal = 1L + this.values.nextOrd();
            return this.currentOrdinal;
        }

        @Override
        public LongsRef getOrds(int docId) {
            this.values.setDocument(docId);
            this.longScratch.offset = 0;
            this.longScratch.length = 0;
            long ord = this.values.nextOrd();
            while (ord != -1L) {
                this.longScratch.longs = ArrayUtil.grow((long[])this.longScratch.longs, (int)(this.longScratch.length + 1));
                this.longScratch.longs[this.longScratch.length++] = 1L + ord;
                ord = this.values.nextOrd();
            }
            return this.longScratch;
        }

        @Override
        public long nextOrd() {
            assert (this.ordIndex < this.longScratch.length);
            this.currentOrdinal = this.longScratch.longs[this.ordIndex++];
            return this.currentOrdinal;
        }

        @Override
        public int setDocument(int docId) {
            LongsRef ords = this.getOrds(docId);
            this.ordIndex = 0;
            return ords.length;
        }

        @Override
        public long currentOrd() {
            return this.currentOrdinal;
        }
    }

    static final class SortedSetOrdinals
    implements Ordinals {
        private final AtomicReader reader;
        private final String field;
        private final long numOrds;

        public SortedSetOrdinals(AtomicReader reader, String field, long numOrds) {
            this.reader = reader;
            this.field = field;
            this.numOrds = numOrds;
        }

        @Override
        public long getMemorySizeInBytes() {
            return -1L;
        }

        @Override
        public boolean isMultiValued() {
            return true;
        }

        @Override
        public int getNumDocs() {
            return this.reader.maxDoc();
        }

        @Override
        public long getNumOrds() {
            return this.numOrds;
        }

        @Override
        public long getMaxOrd() {
            return 1L + this.numOrds;
        }

        @Override
        public Ordinals.Docs ordinals() {
            SortedSetDocValues values = SortedSetDVAtomicFieldData.getValuesNoException(this.reader, this.field);
            assert (values.getValueCount() == this.numOrds);
            return new SortedSetDocs(this, values);
        }
    }

    static final class SortedSetHashedValues
    extends SortedSetValues {
        private final IntArray hashes;

        SortedSetHashedValues(AtomicReader reader, String field, SortedSetDocValues values, IntArray hashes) {
            super(reader, field, values);
            this.hashes = hashes;
        }

        @Override
        public int currentValueHash() {
            assert (this.ordinals.currentOrd() >= 0L);
            return this.hashes.get(this.ordinals.currentOrd());
        }
    }

    static class SortedSetValues
    extends BytesValues.WithOrdinals {
        protected final SortedSetDocValues values;

        SortedSetValues(AtomicReader reader, String field, SortedSetDocValues values) {
            super(new SortedSetDocs(new SortedSetOrdinals(reader, field, values.getValueCount()), values));
            this.values = values;
        }

        @Override
        public BytesRef getValueByOrd(long ord) {
            assert (ord != 0L);
            this.values.lookupOrd(ord - 1L, this.scratch);
            return this.scratch;
        }

        @Override
        public BytesRef nextValue() {
            this.values.lookupOrd(this.ordinals.nextOrd() - 1L, this.scratch);
            return this.scratch;
        }
    }
}

