/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.common.compress.CompressorContext;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;

@Deprecated
public abstract class CompressedIndexInput<T extends CompressorContext>
extends IndexInput {
    private IndexInput in;
    protected final T context;
    private int version;
    private long totalUncompressedLength;
    private LongArray offsets;
    private boolean closed;
    protected byte[] uncompressed;
    protected int uncompressedLength;
    private int position = 0;
    private int valid = 0;
    private int currentOffsetIdx;
    private long currentUncompressedChunkPointer;

    public CompressedIndexInput(IndexInput in, T context) throws IOException {
        super("compressed(" + in.toString() + ")");
        this.in = in;
        this.context = context;
        this.readHeader(in);
        this.version = in.readInt();
        long metaDataPosition = in.readLong();
        long headerLength = in.getFilePointer();
        in.seek(metaDataPosition);
        this.totalUncompressedLength = in.readVLong();
        int size = in.readVInt();
        this.offsets = BigArrays.newLongArray(size);
        for (int i = 0; i < size; ++i) {
            this.offsets.set(i, in.readVLong());
        }
        this.currentOffsetIdx = -1;
        this.currentUncompressedChunkPointer = 0L;
        in.seek(headerLength);
    }

    public int available() throws IOException {
        if (this.closed) {
            return -1;
        }
        int left = this.valid - this.position;
        return left <= 0 ? 0 : left;
    }

    public byte readByte() throws IOException {
        if (!this.readyBuffer()) {
            throw new EOFException();
        }
        return this.uncompressed[this.position++];
    }

    public int read(byte[] buffer, int offset, int length, boolean fullRead) throws IOException {
        if (length < 1) {
            return 0;
        }
        if (!this.readyBuffer()) {
            return -1;
        }
        int chunkLength = Math.min(this.valid - this.position, length);
        System.arraycopy(this.uncompressed, this.position, buffer, offset, chunkLength);
        this.position += chunkLength;
        if (chunkLength == length || !fullRead) {
            return chunkLength;
        }
        int totalRead = chunkLength;
        do {
            offset += chunkLength;
            if (!this.readyBuffer()) break;
            chunkLength = Math.min(this.valid - this.position, length - totalRead);
            System.arraycopy(this.uncompressed, this.position, buffer, offset, chunkLength);
            this.position += chunkLength;
        } while ((totalRead += chunkLength) < length);
        return totalRead;
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        int result = this.read(b, offset, len, true);
        if (result < len) {
            throw new EOFException();
        }
    }

    public long getFilePointer() {
        return this.currentUncompressedChunkPointer + (long)this.position;
    }

    public void seek(long pos) throws IOException {
        int idx = (int)(pos / (long)this.uncompressedLength);
        if ((long)idx >= this.offsets.size()) {
            this.currentOffsetIdx = idx;
            this.position = 0;
            this.valid = 0;
            return;
        }
        if (idx != this.currentOffsetIdx) {
            long pointer = this.offsets.get(idx);
            this.in.seek(pointer);
            this.position = 0;
            this.valid = 0;
            this.currentOffsetIdx = idx - 1;
            this.readyBuffer();
        }
        this.position = (int)(pos % (long)this.uncompressedLength);
    }

    public long length() {
        return this.totalUncompressedLength;
    }

    public void close() throws IOException {
        this.valid = 0;
        this.position = 0;
        if (!this.closed) {
            this.closed = true;
            this.doClose();
            this.in.close();
        }
    }

    protected abstract void doClose() throws IOException;

    protected boolean readyBuffer() throws IOException {
        if (this.position < this.valid) {
            return true;
        }
        if (this.closed) {
            return false;
        }
        if ((long)(this.currentOffsetIdx + 1) >= this.offsets.size()) {
            return false;
        }
        this.valid = this.uncompress(this.in, this.uncompressed);
        if (this.valid < 0) {
            return false;
        }
        ++this.currentOffsetIdx;
        this.currentUncompressedChunkPointer = (long)this.currentOffsetIdx * (long)this.uncompressedLength;
        this.position = 0;
        return this.position < this.valid;
    }

    protected abstract void readHeader(IndexInput var1) throws IOException;

    protected abstract int uncompress(IndexInput var1, byte[] var2) throws IOException;

    public IndexInput clone() {
        CompressedIndexInput cloned = (CompressedIndexInput)super.clone();
        cloned.uncompressed = new byte[this.uncompressedLength];
        System.arraycopy(this.uncompressed, 0, cloned.uncompressed, 0, this.uncompressedLength);
        cloned.in = cloned.in.clone();
        return cloned;
    }
}

